/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.resourcePack;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.ResourcePack;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;

public class ResolutionCommand
extends SubCommand {
    public ResolutionCommand() {
        EmptyCommand emptyResolutionResolution = new EmptyCommand();
        emptyResolutionResolution.setCommandName("resolution", ArgumentType.OPTIONAL);
        emptyResolutionResolution.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.resourcePack.resolution.resolution.commandDescription", "custom"));
        this.addAction(emptyResolutionResolution);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.resourcePack.resolution.commandDescription", new Object[0]));
    }

    @Override
    public String getName(String arg) {
        return "resolution";
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return Resolution.getStringValues();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            ColorTheme.sendInfoTranslation(player, "tport.command.resourcePack.resolution.succeeded", ResourcePack.getResourcePackResolution(player.getUniqueId()));
            Message resolutionsMessage = new Message();
            Message delimiter = ColorTheme.formatInfoTranslation("tport.command.resourcePack.resolution.delimiter", new Object[0]);
            ArrayList<Resolution> resolutions = Resolution.getResolutions();
            boolean color = true;
            for (int i = 0; i < resolutions.size(); ++i) {
                Resolution res = resolutions.get(i);
                resolutionsMessage.addMessage(ColorTheme.formatTranslation(color ? ColorTheme.ColorType.varInfoColor : ColorTheme.ColorType.varInfo2Color, color ? ColorTheme.ColorType.varInfoColor : ColorTheme.ColorType.varInfo2Color, "%s", res));
                boolean bl = color = !color;
                if (i + 2 == resolutions.size()) {
                    resolutionsMessage.addMessage(ColorTheme.formatInfoTranslation("tport.command.resourcePack.resolution.lastDelimiter", new Object[0]));
                    continue;
                }
                resolutionsMessage.addMessage(delimiter);
            }
            resolutionsMessage.removeLast();
            ColorTheme.sendInfoTranslation(player, "tport.command.resourcePack.resolution.allResolutions", resolutionsMessage);
        } else if (args.length == 3) {
            Resolution newResolution = Resolution.getResolution(args[2]);
            if (newResolution == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport resourcePack state [true|false]");
                return;
            }
            Resolution currentResolution = ResourcePack.getResourcePackResolution(player.getUniqueId());
            if (newResolution == currentResolution) {
                ColorTheme.sendErrorTranslation(player, "tport.command.resourcePack.resolution.resolution.alreadyInResolution", currentResolution);
                return;
            }
            ResourcePack.setResourcePackResolution(player.getUniqueId(), newResolution);
            ResourcePack.updateResourcePack(player, false);
            ColorTheme.sendSuccessTranslation(player, "tport.command.resourcePack.resolution.resolution.succeeded", newResolution);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport resourcePack resolution [resolution]");
        }
    }

    public static class Resolution {
        private static final ArrayList<Resolution> resolutions = new ArrayList();
        private final String name;
        private final String url;

        private Resolution(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Resolution that = (Resolution)o;
            return this.name.equalsIgnoreCase(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public Message getDescription() {
            return ColorTheme.formatInfoTranslation("tport.command.resourcePack.resolution.resolution." + this.name + ".description", new Object[0]);
        }

        public static boolean registerResourcePackResolution(String name, String url) {
            if (resolutions.stream().noneMatch(res -> res.name.equalsIgnoreCase(name))) {
                resolutions.add(new Resolution(name, url));
                return true;
            }
            return false;
        }

        public static Resolution getResolution(String name) {
            return Resolution.getResolution(name, null);
        }

        public static Resolution getResolution(String name, @Nullable String def) {
            Resolution defRes = null;
            for (Resolution res : resolutions) {
                if (res.name.equalsIgnoreCase(name)) {
                    return res;
                }
                if (!res.name.equalsIgnoreCase(def)) continue;
                defRes = res;
            }
            return defRes;
        }

        public static List<String> getStringValues() {
            return resolutions.stream().map(Resolution::getName).collect(Collectors.toList());
        }

        public static ArrayList<Resolution> getResolutions() {
            return new ArrayList<Resolution>(resolutions);
        }
    }
}

