/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.requests;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.requests.Accept;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tpEvents.TPRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.entity.Player;

public class Reject
extends SubCommand {
    public Reject() {
        EmptyCommand emptyPlayer = new EmptyCommand();
        emptyPlayer.setCommandName("player", ArgumentType.OPTIONAL);
        emptyPlayer.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.requests.reject.players.commandDescription", new Object[0]));
        emptyPlayer.setTabRunnable((args, player) -> Accept.consentTabList(player.getUniqueId(), Arrays.asList(args).subList(1, args.length)));
        emptyPlayer.setLooped(true);
        this.addAction(emptyPlayer);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.requests.reject.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return Accept.consentTabList(player.getUniqueId(), Arrays.asList(args).subList(1, args.length));
    }

    @Override
    public void run(String[] args, Player player) {
        ArrayList<TPRequest> list = TPRequest.getRequestsToYou(player.getUniqueId());
        if (args.length == 2) {
            if (list.size() == 1) {
                TPRequest request = list.get(0);
                request.rejectRequest();
            } else if (list.isEmpty()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.requests.reject.noPending", new Object[0]);
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.requests.reject.tooManyPending", new Object[0]);
            }
        } else {
            block0: for (int i = 2; i < args.length; ++i) {
                UUID requesterUUID = PlayerUUID.getPlayerUUID(args[i], player);
                if (requesterUUID == null) continue;
                for (TPRequest request : list) {
                    if (!request.getRequesterUUID().equals(requesterUUID)) continue;
                    request.rejectRequest();
                    list.remove(request);
                    continue block0;
                }
                ColorTheme.sendErrorTranslation(player, "tport.command.requests.reject.players.notRequesting", PlayerEncapsulation.asPlayer(requesterUUID));
            }
        }
    }
}

