/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.publc;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Remove
extends SubCommand {
    private static final Remove instance = new Remove();
    public final EmptyCommand emptyAll;

    public static Remove getInstance() {
        return instance;
    }

    private Remove() {
        EmptyCommand emptyOwn = new EmptyCommand();
        emptyOwn.setCommandName("own TPort name", ArgumentType.REQUIRED);
        emptyOwn.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.public.remove.own.commandDescription", new Object[0]));
        this.emptyAll = new EmptyCommand();
        this.emptyAll.setCommandName("all TPort name", ArgumentType.REQUIRED);
        this.emptyAll.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.public.remove.all.commandDescription", new Object[0]));
        this.emptyAll.setPermissions("TPort.public.remove.all", "TPort.admin.public");
        this.addAction(emptyOwn);
        this.addAction(this.emptyAll);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        for (String publicTPortSlot : Files.tportData.getKeys("public.tports")) {
            String tportID = Files.tportData.getConfig().getString("public.tports." + publicTPortSlot, TPortManager.defUUID.toString());
            TPort tport = TPortManager.getTPort(UUID.fromString(tportID));
            if (tport == null) continue;
            if (tport.getOwner().equals(player.getUniqueId())) {
                list.add(tport.getName());
                continue;
            }
            if (!this.emptyAll.hasPermissionToRun(player, false)) continue;
            list.add(tport.getName());
        }
        return list;
    }

    public static void removePublicTPort(String name, Player player, boolean fromDelete) {
        for (String publicTPortSlot : Files.tportData.getKeys("public.tports")) {
            String tportID = Files.tportData.getConfig().getString("public.tports." + publicTPortSlot, TPortManager.defUUID.toString());
            TPort tport = TPortManager.getTPort(UUID.fromString(tportID));
            if (tport == null) {
                return;
            }
            if (!tport.getName().equalsIgnoreCase(name)) continue;
            if (tport.getOwner().equals(player.getUniqueId())) {
                int publicSlot;
                if (tport.isOffered()) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.public.remove.own.isOffered", TPortEncapsulation.asTPort(tport.parseAsPublic(true)), PlayerEncapsulation.asPlayer(tport.getOfferedTo()));
                    return;
                }
                try {
                    publicSlot = Integer.parseInt(publicTPortSlot) + 1;
                }
                catch (NumberFormatException nfe) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.public.remove.errorInFile", TPortEncapsulation.asTPort(tport.parseAsPublic(true)), "TPortData.yml");
                    return;
                }
                Files.tportData.getConfig().set("public.tports." + publicTPortSlot, null);
                tport.setPublicTPort(false);
                tport.save();
                ColorTheme.sendSuccessTranslation(player, "tport.command.public.remove.own.succeeded", TPortEncapsulation.asTPort(tport));
                while (Files.tportData.getConfig().contains("public.tports." + publicSlot)) {
                    String publicTPort = Files.tportData.getConfig().getString("public.tports." + publicSlot, TPortManager.defUUID.toString());
                    Files.tportData.getConfig().set("public.tports." + (publicSlot - 1), (Object)publicTPort);
                    Files.tportData.getConfig().set("public.tports." + publicSlot, null);
                    ++publicSlot;
                }
                Files.tportData.saveConfig();
                return;
            }
            if (!fromDelete) {
                int publicSlot;
                if (!Remove.getInstance().emptyAll.hasPermissionToRun(player, true)) {
                    return;
                }
                try {
                    publicSlot = Integer.parseInt(publicTPortSlot) + 1;
                }
                catch (NumberFormatException nfe) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.public.remove.errorInFile", TPortEncapsulation.asTPort(tport.parseAsPublic(true)), "TPortData.yml");
                    return;
                }
                Files.tportData.getConfig().set("public.tports." + publicTPortSlot, null);
                tport.setPublicTPort(false);
                if (tport.isOffered()) {
                    ColorTheme.sendInfoTranslation(Bukkit.getPlayer((UUID)tport.getOfferedTo()), "tport.command.public.remove.all.offeredPlayer", TPortEncapsulation.asTPort(tport), PlayerEncapsulation.asPlayer(tport.getOwner()));
                }
                tport.save();
                ColorTheme.sendSuccessTranslation(player, "tport.command.public.remove.all.succeeded", TPortEncapsulation.asTPort(tport), PlayerEncapsulation.asPlayer(tport.getOwner()));
                ColorTheme.sendInfoTranslation(Bukkit.getPlayer((UUID)tport.getOwner()), "tport.command.public.remove.all.owner", PlayerEncapsulation.asPlayer(player), TPortEncapsulation.asTPort(tport));
                while (Files.tportData.getConfig().contains("public.tports." + publicSlot)) {
                    String publicTPort = Files.tportData.getConfig().getString("public.tports." + publicSlot, TPortManager.defUUID.toString());
                    Files.tportData.getConfig().set("public.tports." + (publicSlot - 1), (Object)publicTPort);
                    Files.tportData.getConfig().set("public.tports." + publicSlot, null);
                    ++publicSlot;
                }
                Files.tportData.saveConfig();
                return;
            }
            return;
        }
        if (!fromDelete) {
            ColorTheme.sendErrorTranslation(player, "tport.command.public.TPortNotFound", name);
        }
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 3) {
            Remove.removePublicTPort(args[2], player, false);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport public remove <TPort name>");
        }
    }
}

