/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.publc;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ListSize
extends SubCommand {
    private final EmptyCommand emptySize = new EmptyCommand();

    public ListSize() {
        this.emptySize.setCommandName("size", ArgumentType.OPTIONAL);
        this.emptySize.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.public.listSize.size.commandDescription", new Object[0]));
        this.emptySize.setPermissions("TPort.public.listSize", "TPort.admin.public");
        this.addAction(this.emptySize);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.public.listSize.commandDescription", new Object[0]));
    }

    public static int getPublicTPortSize() {
        return Files.tportConfig.getConfig().getInt("public.size", 70);
    }

    public static int getTPortAmount() {
        return Files.tportData.getKeys("public.tports").size();
    }

    private static void setPublicTPortSize(int size) {
        for (int publicSlot = size; publicSlot < ListSize.getPublicTPortSize(); ++publicSlot) {
            if (!Files.tportData.getConfig().contains("public.tports." + publicSlot)) continue;
            String tportID = Files.tportData.getConfig().getString("public.tports." + publicSlot, TPortManager.defUUID.toString());
            TPort tport = TPortManager.getTPort(UUID.fromString(tportID));
            Files.tportData.getConfig().set("public.tports." + publicSlot, null);
            if (tport == null) continue;
            tport.setPublicTPort(false);
            tport.save();
            Player owner = Bukkit.getPlayer((UUID)tport.getOwner());
            if (owner == null) continue;
            ColorTheme.sendInfoTranslation(owner, "tport.command.public.listSize.size.removedSmallerList", tport);
        }
        Files.tportData.saveConfig();
        Files.tportConfig.getConfig().set("public.size", (Object)size);
        Files.tportConfig.saveConfig();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            ColorTheme.sendInfoTranslation(player, "tport.command.public.listSize.succeeded", ListSize.getPublicTPortSize());
        } else if (args.length == 3) {
            if (!this.emptySize.hasPermissionToRun(player, true)) {
                return;
            }
            try {
                ListSize.setPublicTPortSize(Integer.parseInt(args[2]));
                ColorTheme.sendSuccessTranslation(player, "tport.command.public.listSize.size.succeeded", args[2]);
            }
            catch (NumberFormatException nfe) {
                ColorTheme.sendErrorTranslation(player, "tport.command.public.listSize.size.invalidNumber", args[2]);
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport public listSize [size]");
        }
    }
}

