/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.publc;

import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Own;
import com.spaceman.tport.commands.tport.publc.ListSize;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;

public class Add
extends SubCommand {
    private final EmptyCommand emptyTPort = new EmptyCommand();

    public Add() {
        this.emptyTPort.setCommandName("TPort name", ArgumentType.REQUIRED);
        this.emptyTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.public.add.tport.commandDescription", new Object[0]));
        this.emptyTPort.setPermissions("TPort.public.add");
        this.addAction(this.emptyTPort);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        List<String> list = Own.getOwnTPorts(player);
        if (!this.emptyTPort.hasPermissionToRun(player, false)) {
            return list;
        }
        for (String publicTPortSlot : Files.tportData.getKeys("public.tports")) {
            String tportID = Files.tportData.getConfig().getString("public.tports." + publicTPortSlot, TPortManager.defUUID.toString());
            TPort tport = TPortManager.getTPort(UUID.fromString(tportID));
            if (tport == null || !tport.getOwner().equals(player.getUniqueId())) continue;
            list.add(tport.getName());
        }
        return list;
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 3) {
            if (!this.emptyTPort.hasPermissionToRun(player, true)) {
                return;
            }
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[2]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[2]);
                return;
            }
            if (tport.isOffered()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.public.add.tport.isOffered", TPortEncapsulation.asTPort(tport), PlayerEncapsulation.asPlayer(tport.getOfferedTo()));
                return;
            }
            for (int publicSlot = 0; publicSlot < ListSize.getPublicTPortSize(); ++publicSlot) {
                if (!Files.tportData.getConfig().contains("public.tports." + publicSlot)) {
                    Files.tportData.getConfig().set("public.tports." + publicSlot, (Object)tport.getTportID().toString());
                    Files.tportData.saveConfig();
                    tport.setPublicTPort(true, player);
                    tport.save();
                    ColorTheme.sendSuccessTranslation(player, "tport.command.public.add.tport.succeeded", TPortEncapsulation.asTPort(tport.parseAsPublic(true)));
                    TPortAdvancement.Advancement_whatsMineIsYours.grant(player);
                    return;
                }
                String tportID = Files.tportData.getConfig().getString("public.tports." + publicSlot, TPortManager.defUUID.toString());
                TPort tmpTPort = TPortManager.getTPort(UUID.fromString(tportID));
                if (tmpTPort == null || !tmpTPort.getName().equalsIgnoreCase(tport.getName())) continue;
                ColorTheme.sendErrorTranslation(player, "tport.command.public.add.tport.nameUsed", tport, TPortEncapsulation.asTPort(tmpTPort.parseAsPublic(true)));
                return;
            }
            ColorTheme.sendErrorTranslation(player, "tport.command.public.add.tport.isFull", TPortEncapsulation.asTPort(tport));
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport public add <TPort name>");
        }
    }
}

