/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.pltp.whitelist;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.pltp.Whitelist;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.playerUUID.PlayerUUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Remove
extends SubCommand {
    public Remove() {
        EmptyCommand emptyRemove = new EmptyCommand();
        emptyRemove.setCommandName("player", ArgumentType.REQUIRED);
        emptyRemove.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.PLTP.whitelist.remove.players.commandDescription", new Object[0]));
        emptyRemove.setTabRunnable((args, player) -> {
            List list = Whitelist.getPLTPWhitelist(player).stream().map(PlayerUUID::getPlayerName).collect(Collectors.toList());
            list.removeAll(Arrays.asList(args).subList(3, args.length));
            return list;
        });
        emptyRemove.setLooped(true);
        this.addAction(emptyRemove);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return this.getActions().get(0).tabList(player, args);
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length < 4) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport PLTP whitelist remove <player...>");
            return;
        }
        ArrayList<String> list = Whitelist.getPLTPWhitelist(player);
        for (int i = 3; i < args.length; ++i) {
            String removePlayerName = args[i];
            UUID removePlayerUUID = PlayerUUID.getPlayerUUID(removePlayerName, player);
            if (removePlayerUUID == null) {
                return;
            }
            if (!list.contains(removePlayerUUID.toString())) {
                ColorTheme.sendErrorTranslation(player, "tport.command.PLTP.whitelist.remove.players.notInList", PlayerEncapsulation.asPlayer(removePlayerUUID));
                return;
            }
            list.remove(removePlayerUUID.toString());
            Whitelist.setPLTPWhitelist(player, list);
            ColorTheme.sendSuccessTranslation(player, "tport.command.PLTP.whitelist.remove.players.succeeded", PlayerEncapsulation.asPlayer(removePlayerUUID));
            ColorTheme.sendInfoTranslation(Bukkit.getPlayer((UUID)removePlayerUUID), "tport.command.PLTP.whitelist.remove.players.succeededOtherPlayer", PlayerEncapsulation.asPlayer(player));
        }
    }
}

