/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.pltp.whitelist;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.pltp.Whitelist;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.playerUUID.PlayerUUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Add
extends SubCommand {
    private final EmptyCommand emptyPlayer = new EmptyCommand();

    public Add() {
        this.emptyPlayer.setCommandName("player", ArgumentType.REQUIRED);
        this.emptyPlayer.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.PLTP.whitelist.add.players.commandDescription", new Object[0]));
        this.emptyPlayer.setTabRunnable((args, player) -> {
            if (this.emptyPlayer.hasPermissionToRun(player, false)) {
                return Collections.emptyList();
            }
            ArrayList<String> list = PlayerUUID.getPlayerNames();
            list.remove(player.getName());
            Whitelist.getPLTPWhitelist(player).stream().map(PlayerUUID::getPlayerName).filter(Objects::nonNull).forEach(list::remove);
            list.removeAll(Arrays.asList(args).subList(3, args.length));
            return list;
        });
        this.emptyPlayer.setLooped(true);
        this.emptyPlayer.setPermissions("TPort.PLTP.edit", "TPort.basic");
        this.addAction(this.emptyPlayer);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptyPlayer.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return this.emptyPlayer.tabList(player, args);
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length < 4) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport PLTP whitelist add <player...>");
            return;
        }
        if (!this.emptyPlayer.hasPermissionToRun(player, true)) {
            return;
        }
        ArrayList<String> list = Whitelist.getPLTPWhitelist(player);
        for (int i = 3; i < args.length; ++i) {
            String addPlayerName = args[i];
            UUID addPlayerUUID = PlayerUUID.getPlayerUUID(addPlayerName, player);
            if (addPlayerUUID == null) {
                return;
            }
            if (addPlayerUUID.equals(player.getUniqueId())) {
                ColorTheme.sendErrorTranslation(player, "tport.command.PLTP.whitelist.add.players.yourself", new Object[0]);
                continue;
            }
            if (list.contains(addPlayerUUID.toString())) {
                ColorTheme.sendErrorTranslation(player, "tport.command.PLTP.whitelist.add.players.alreadyInList", PlayerEncapsulation.asPlayer(addPlayerUUID));
                continue;
            }
            list.add(addPlayerUUID.toString());
            Whitelist.setPLTPWhitelist(player, list);
            ColorTheme.sendSuccessTranslation(player, "tport.command.PLTP.whitelist.add.players.succeeded", PlayerEncapsulation.asPlayer(addPlayerUUID));
            ColorTheme.sendInfoTranslation(Bukkit.getPlayer((UUID)addPlayerUUID), "tport.command.PLTP.whitelist.add.players.succeededOtherPlayer", PlayerEncapsulation.asPlayer(player));
        }
    }
}

