/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.pltp;

import com.spaceman.tport.Main;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.bukkit.entity.Player;

public class State
extends SubCommand {
    private final EmptyCommand emptyState = new EmptyCommand();

    public State() {
        this.emptyState.setCommandName("state", ArgumentType.OPTIONAL);
        this.emptyState.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.PLTP.state.state.commandDescription", ColorTheme.formatTranslation(ColorTheme.ColorType.goodColor, ColorTheme.ColorType.varInfo2Color, "tport.command.PLTP.state.enabled", new Object[0]), ColorTheme.formatTranslation(ColorTheme.ColorType.badColor, ColorTheme.ColorType.varInfo2Color, "tport.command.PLTP.state.disabled", new Object[0])));
        this.emptyState.setPermissions("TPort.PLTP.state.set", "TPort.basic");
        this.addAction(this.emptyState);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.PLTP.state.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptyState.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Arrays.asList("true", "false");
    }

    public static boolean getPLTPState(Player player) {
        return State.getPLTPState(player.getUniqueId());
    }

    public static boolean getPLTPState(UUID uuid) {
        return Files.tportData.getConfig().getBoolean("tport." + String.valueOf(uuid) + ".tp.statement", true);
    }

    public static void setPLTPState(Player player, boolean pltpState) {
        Files.tportData.getConfig().set("tport." + String.valueOf(player.getUniqueId()) + ".tp.statement", (Object)pltpState);
        Files.tportData.saveConfig();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            boolean pltpState = State.getPLTPState(player);
            ColorTheme.sendInfoTranslation(player, "tport.command.PLTP.state.succeeded", pltpState ? ColorTheme.formatTranslation(ColorTheme.ColorType.goodColor, ColorTheme.ColorType.varInfo2Color, "tport.command.PLTP.state.enabled", new Object[0]) : ColorTheme.formatTranslation(ColorTheme.ColorType.badColor, ColorTheme.ColorType.varInfo2Color, "tport.command.PLTP.state.disabled", new Object[0]));
        } else if (args.length == 3) {
            if (!this.emptyState.hasPermissionToRun(player, true)) {
                return;
            }
            Boolean pltpState = Main.toBoolean(args[2]);
            if (pltpState == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport PLTP state [true|false]");
                return;
            }
            boolean oldPltpState = State.getPLTPState(player);
            if (pltpState == oldPltpState) {
                ColorTheme.sendErrorTranslation(player, "tport.command.PLTP.state.state.alreadyInState", pltpState != false ? ColorTheme.formatTranslation(ColorTheme.ColorType.goodColor, ColorTheme.ColorType.varInfo2Color, "tport.command.PLTP.state.enabled", new Object[0]) : ColorTheme.formatTranslation(ColorTheme.ColorType.badColor, ColorTheme.ColorType.varInfo2Color, "tport.command.PLTP.state.disabled", new Object[0]));
            } else {
                State.setPLTPState(player, pltpState);
                ColorTheme.sendSuccessTranslation(player, "tport.command.PLTP.state.state.succeeded", pltpState != false ? ColorTheme.formatTranslation(ColorTheme.ColorType.goodColor, ColorTheme.ColorType.varInfo2Color, "tport.command.PLTP.state.enabled", new Object[0]) : ColorTheme.formatTranslation(ColorTheme.ColorType.badColor, ColorTheme.ColorType.varInfo2Color, "tport.command.PLTP.state.disabled", new Object[0]));
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport PLTP state [state]");
        }
    }
}

