/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.pltp;

import com.spaceman.tport.Main;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.bukkit.entity.Player;

public class Consent
extends SubCommand {
    private final EmptyCommand emptyState = new EmptyCommand();

    public Consent() {
        this.emptyState.setCommandName("state", ArgumentType.OPTIONAL);
        this.emptyState.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.PLTP.consent.state.commandDescription", ColorTheme.formatTranslation(ColorTheme.ColorType.goodColor, ColorTheme.ColorType.varInfo2Color, "tport.command.PLTP.consent.enabled", new Object[0]), ColorTheme.formatTranslation(ColorTheme.ColorType.badColor, ColorTheme.ColorType.varInfo2Color, "tport.command.PLTP.consent.disabled", new Object[0])));
        this.emptyState.setPermissions("TPort.PLTP.consent.set", "TPort.basic");
        this.addAction(this.emptyState);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.PLTP.consent.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptyState.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Arrays.asList("true", "false");
    }

    public static boolean shouldAskConsent(Player player) {
        return Consent.shouldAskConsent(player.getUniqueId());
    }

    public static boolean shouldAskConsent(UUID uuid) {
        return Files.tportData.getConfig().getBoolean("tport." + String.valueOf(uuid) + ".tp.consent", false);
    }

    public static void shouldAskConsent(Player player, boolean consentState) {
        Files.tportData.getConfig().set("tport." + String.valueOf(player.getUniqueId()) + ".tp.consent", (Object)consentState);
        Files.tportData.saveConfig();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            boolean pltpState = Consent.shouldAskConsent(player);
            ColorTheme.sendInfoTranslation(player, "tport.command.PLTP.consent.succeeded", pltpState ? ColorTheme.formatTranslation(ColorTheme.ColorType.goodColor, ColorTheme.ColorType.varInfo2Color, "tport.command.PLTP.consent.enabled", new Object[0]) : ColorTheme.formatTranslation(ColorTheme.ColorType.badColor, ColorTheme.ColorType.varInfo2Color, "tport.command.PLTP.consent.disabled", new Object[0]));
        } else if (args.length == 3) {
            if (!this.emptyState.hasPermissionToRun(player, true)) {
                return;
            }
            Boolean consentState = Main.toBoolean(args[2]);
            if (consentState == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport PLTP consent [true|false]");
                return;
            }
            boolean oldConsentState = Consent.shouldAskConsent(player);
            if (consentState == oldConsentState) {
                ColorTheme.sendSuccessTranslation(player, "tport.command.PLTP.consent.state.alreadyInState", consentState != false ? ColorTheme.formatTranslation(ColorTheme.ColorType.goodColor, ColorTheme.ColorType.varInfo2Color, "tport.command.PLTP.consent.enabled", new Object[0]) : ColorTheme.formatTranslation(ColorTheme.ColorType.badColor, ColorTheme.ColorType.varInfo2Color, "tport.command.PLTP.consent.disabled", new Object[0]));
            } else {
                Consent.shouldAskConsent(player, consentState);
                ColorTheme.sendSuccessTranslation(player, "tport.command.PLTP.consent.state.succeeded", consentState != false ? ColorTheme.formatTranslation(ColorTheme.ColorType.goodColor, ColorTheme.ColorType.varInfo2Color, "tport.command.PLTP.consent.enabled", new Object[0]) : ColorTheme.formatTranslation(ColorTheme.ColorType.badColor, ColorTheme.ColorType.varInfo2Color, "tport.command.PLTP.consent.disabled", new Object[0]));
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport PLTP consent [state]");
        }
    }
}

