/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.log;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.log.LogSize;
import com.spaceman.tport.commands.tport.log.TimeFormat;
import com.spaceman.tport.commands.tport.log.TimeZone;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.inventories.QuickEditInventories;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;

public class Read
extends SubCommand {
    public Read() {
        EmptyCommand emptyTPortPlayer = new EmptyCommand();
        emptyTPortPlayer.setCommandName("player", ArgumentType.OPTIONAL);
        emptyTPortPlayer.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.log.read.tportName.player.commandDescription", new Object[0]));
        EmptyCommand emptyTPort = new EmptyCommand();
        emptyTPort.setCommandName("TPort name", ArgumentType.REQUIRED);
        emptyTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.log.read.tportName.commandDescription", LogSize.getLogSize()));
        emptyTPort.setTabRunnable((args, player) -> {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[2]);
            if (tport != null) {
                return tport.getLogBook().stream().map(p -> PlayerUUID.getPlayerName(p.teleportedUUID())).collect(Collectors.toList());
            }
            return Collections.emptyList();
        });
        emptyTPort.addAction(emptyTPortPlayer);
        this.addAction(emptyTPort);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return TPortManager.getTPortList(player.getUniqueId()).stream().filter(tport -> !tport.isLogBookEmpty()).map(TPort::getName).collect(Collectors.toList());
    }

    public static void readLog_chat(Player player, TPort tport) {
        ArrayList<TPort.LogEntry> log = tport.getLogBook();
        if (log.isEmpty()) {
            ColorTheme.sendInfoTranslation(player, "tport.command.log.read.tportName.isEmpty", TPortEncapsulation.asTPort(tport));
            return;
        }
        String format = TimeFormat.getTimeFormat(player);
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(TimeZone.getTimeZone(player));
        Message logMessage = new Message();
        boolean color = true;
        int logSize = log.size();
        for (int i = 0; i < logSize; ++i) {
            TPort.LogEntry logEntry = log.get(i);
            PlayerEncapsulation playerRepresentation = PlayerEncapsulation.asPlayer(logEntry.teleportedUUID());
            if (color) {
                ownerOnlineComponent = new TextComponent(String.valueOf(logEntry.ownerOnline()), ColorTheme.ColorType.varInfoColor);
                ownerOnlineComponent.addTextEvent(new HoverEvent(ColorTheme.formatInfoTranslation("tport.tport.tport.logEntry." + logEntry.ownerOnline() + ".description", new Object[0])));
                logMessage.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.log.read.tportName.listElement", sdf.format(logEntry.timeOfTeleport().getTime()), playerRepresentation, logEntry.loggedMode() == null ? "???" : logEntry.loggedMode(), logEntry.ownerOnline() == null ? "???" : ownerOnlineComponent));
            } else {
                ownerOnlineComponent = new TextComponent(String.valueOf(logEntry.ownerOnline()), ColorTheme.ColorType.varInfo2Color);
                ownerOnlineComponent.addTextEvent(new HoverEvent(ColorTheme.formatInfoTranslation("tport.tport.tport.logEntry." + logEntry.ownerOnline() + ".description", new Object[0])));
                logMessage.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.log.read.tportName.listElement", sdf.format(logEntry.timeOfTeleport().getTime()), playerRepresentation, logEntry.loggedMode() == null ? "???" : logEntry.loggedMode(), logEntry.ownerOnline() == null ? "???" : ownerOnlineComponent));
            }
            if (i + 2 == logSize) {
                logMessage.addMessage(ColorTheme.formatInfoTranslation("tport.command.log.read.tportName.lastDelimiter", new Object[0]));
            } else {
                logMessage.addMessage(ColorTheme.formatInfoTranslation("tport.command.log.read.tportName.delimiter", new Object[0]));
            }
            color = !color;
        }
        logMessage.removeLast();
        ColorTheme.sendInfoTranslation(player, "tport.command.log.read.tportName.succeeded", TPortEncapsulation.asTPort(tport), logMessage);
    }

    public static void readLog_chat(Player player, TPort tport, @Nullable UUID filterUUID) {
        if (filterUUID == null) {
            Read.readLog_chat(player, tport);
            return;
        }
        ArrayList<TPort.LogEntry> log = tport.getLogBook();
        if (log.isEmpty()) {
            ColorTheme.sendInfoTranslation(player, "tport.command.log.read.tportName.isEmpty", TPortEncapsulation.asTPort(tport));
            return;
        }
        String format = Files.tportData.getConfig().getString("tport." + String.valueOf(player.getUniqueId()) + ".timeFormat", "EEE MMM dd HH:mm:ss zzz yyyy");
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(java.util.TimeZone.getTimeZone(Files.tportData.getConfig().getString("tport." + String.valueOf(player.getUniqueId()) + ".timeZone", java.util.TimeZone.getDefault().getID())));
        int size = 0;
        Message logMessage = new Message();
        boolean color = true;
        int logSize = log.size();
        for (int i = 0; i < logSize; ++i) {
            TPort.LogEntry logEntry = log.get(i);
            if (!logEntry.teleportedUUID().equals(filterUUID)) continue;
            PlayerEncapsulation playerRepresentation = PlayerEncapsulation.asPlayer(logEntry.teleportedUUID());
            if (color) {
                logMessage.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.log.read.tportName.player.listElement", sdf.format(logEntry.timeOfTeleport().getTime()), playerRepresentation, logEntry.loggedMode() == null ? "???" : logEntry.loggedMode(), logEntry.ownerOnline() == null ? "???" : logEntry.ownerOnline()));
            } else {
                logMessage.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.log.read.tportName.player.listElement", sdf.format(logEntry.timeOfTeleport().getTime()), playerRepresentation, logEntry.loggedMode() == null ? "???" : logEntry.loggedMode(), logEntry.ownerOnline() == null ? "???" : logEntry.ownerOnline()));
            }
            if (i + 2 == logSize) {
                logMessage.addMessage(ColorTheme.formatInfoTranslation("tport.command.log.read.tportName.player.lastDelimiter", new Object[0]));
            } else {
                logMessage.addMessage(ColorTheme.formatInfoTranslation("tport.command.log.read.tportName.player.delimiter", new Object[0]));
            }
            color = !color;
            ++size;
        }
        logMessage.removeLast();
        if (size == 0) {
            ColorTheme.sendErrorTranslation(player, "tport.command.log.read.tportName.player.playerNotInLog", PlayerEncapsulation.asPlayer(filterUUID), TPortEncapsulation.asTPort(tport));
        } else {
            ColorTheme.sendInfoTranslation(player, "tport.command.log.read.tportName.player.succeeded", TPortEncapsulation.asTPort(tport), PlayerEncapsulation.asPlayer(filterUUID), logMessage);
        }
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 3) {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[2]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[2]);
                return;
            }
            if (!tport.isLogged()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.log.read.tportName.notLogged", TPortEncapsulation.asTPort(tport));
                return;
            }
            QuickEditInventories.openTPortLogReadGUI(player, tport);
        } else if (args.length == 4) {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[2]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[2]);
                return;
            }
            if (!tport.isLogged()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.log.read.tportName.player.notLogged", TPortEncapsulation.asTPort(tport));
                return;
            }
            UUID uuid = PlayerUUID.getPlayerUUID(args[3], player);
            if (uuid == null) {
                return;
            }
            QuickEditInventories.openTPortLogReadGUI(player, tport, uuid);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport log read <TPort name>");
        }
    }
}

