/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.log;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import org.bukkit.entity.Player;

public class LogSize
extends SubCommand {
    private final EmptyCommand emptySize = new EmptyCommand();

    public LogSize() {
        this.emptySize.setCommandName("size", ArgumentType.OPTIONAL);
        this.emptySize.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.log.logSize.size.commandDescription", new Object[0]));
        this.emptySize.setPermissions("TPort.log.logSize", "TPort.admin.log");
        this.addAction(this.emptySize);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.log.logSize.commandDescription", new Object[0]));
    }

    public static int getLogSize() {
        return Files.tportConfig.getConfig().getInt("logbook.size", 50);
    }

    private static void setLogSize(int size) {
        Files.tportConfig.getConfig().set("logbook.size", (Object)size);
        Files.tportConfig.saveConfig();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            ColorTheme.sendInfoTranslation(player, "tport.command.log.logSize.succeeded", LogSize.getLogSize());
        } else if (args.length == 3) {
            if (!this.emptySize.hasPermissionToRun(player, true)) {
                return;
            }
            try {
                int logSize = Integer.parseInt(args[2]);
                LogSize.setLogSize(logSize);
                ColorTheme.sendSuccessTranslation(player, "tport.command.log.logSize.size.succeeded", logSize);
            }
            catch (NumberFormatException nfe) {
                ColorTheme.sendErrorTranslation(player, "tport.command.log.logSize.size.notValidNumber", args[2]);
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport log logSize [size]");
        }
    }
}

