/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.log;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class LogData
extends SubCommand {
    public LogData() {
        EmptyCommand emptyTPortPlayer = new EmptyCommand();
        emptyTPortPlayer.setCommandName("player", ArgumentType.OPTIONAL);
        emptyTPortPlayer.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.log.logData.tportName.player.commandDescription", new Object[0]));
        EmptyCommand emptyTPort = new EmptyCommand();
        emptyTPort.setCommandName("TPort name", ArgumentType.OPTIONAL);
        emptyTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.log.logData.tportName.commandDescription", new Object[0]));
        emptyTPort.setTabRunnable((args, player) -> {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[2]);
            if (tport != null) {
                return tport.getLogged().stream().map(PlayerUUID::getPlayerName).collect(Collectors.toList());
            }
            return Collections.emptyList();
        });
        emptyTPort.addAction(emptyTPortPlayer);
        this.addAction(emptyTPort);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.log.logData.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return TPortManager.getTPortList(player.getUniqueId()).stream().filter(TPort::isLogged).map(TPort::getName).collect(Collectors.toList());
    }

    private Message getLogData(TPort tport, int limitPlayers) {
        Message loggedPlayers = new Message();
        int loggedSize = 0;
        if (tport.hasLoggedPlayers()) {
            List<UUID> logged = tport.getLogged();
            boolean color = true;
            for (int i = 0; i < (loggedSize = logged.size()); ++i) {
                if (i == limitPlayers) {
                    loggedPlayers.removeLast();
                    loggedPlayers.addMessage(ColorTheme.formatInfoTranslation("tport.command.log.logData.tportName.succeeded.limit", new Object[0]));
                    loggedPlayers.addWhiteSpace();
                    break;
                }
                UUID logUUID = logged.get(i);
                loggedPlayers.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, color ? ColorTheme.ColorType.varInfoColor : ColorTheme.ColorType.varInfo2Color, "%s:%s", PlayerEncapsulation.asPlayer(logUUID), tport.getLogMode(logUUID)));
                if (i + 2 == loggedSize) {
                    loggedPlayers.addMessage(ColorTheme.formatInfoTranslation("tport.command.log.logData.tportName.succeeded.lastDelimiter", new Object[0]));
                } else {
                    loggedPlayers.addMessage(ColorTheme.formatInfoTranslation("tport.command.log.logData.tportName.succeeded.delimiter", new Object[0]));
                }
                color = !color;
            }
            loggedPlayers.removeLast();
        }
        String id = loggedSize == 1 ? "tport.command.log.logData.tportName.succeeded.singular" : (loggedSize == 0 ? "tport.command.log.logData.tportName.succeeded.empty" : "tport.command.log.logData.tportName.succeeded.multiple");
        return ColorTheme.formatInfoTranslation(id, tport, tport.getDefaultLogMode(), loggedPlayers);
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            Message tportListMessage = new Message();
            boolean color = true;
            ArrayList<TPort> tportList = TPortManager.getTPortList(player.getUniqueId());
            int loggedSize = 0;
            int loggedMax = (int)tportList.stream().filter(TPort::isLogged).count();
            for (TPort tport : tportList) {
                if (!tport.isLogged()) continue;
                HoverEvent hEvent = new HoverEvent();
                hEvent.addMessage(this.getLogData(tport, 2));
                tportListMessage.addText(TextComponent.textComponent(tport.getName(), color ? ColorTheme.ColorType.varInfoColor : ColorTheme.ColorType.varInfo2Color, hEvent, ClickEvent.runCommand("/tport own " + tport.getName())));
                if (loggedSize + 2 == loggedMax) {
                    tportListMessage.addMessage(ColorTheme.formatInfoTranslation("tport.command.log.logData.succeeded.lastDelimiter", new Object[0]));
                } else {
                    tportListMessage.addMessage(ColorTheme.formatInfoTranslation("tport.command.log.logData.succeeded.delimiter", new Object[0]));
                }
                color = !color;
                ++loggedSize;
            }
            tportListMessage.removeLast();
            if (loggedSize == 0) {
                ColorTheme.sendInfoTranslation(player, "tport.command.log.logData.noLoggedTPorts", new Object[0]);
            } else {
                String id = loggedSize == 1 ? "tport.command.log.logData.succeeded.singular" : "tport.command.log.logData.succeeded.multiple";
                ColorTheme.sendInfoTranslation(player, id, tportListMessage);
            }
        } else if (args.length == 3) {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[2]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[2]);
                return;
            }
            if (tport.isLogged()) {
                this.getLogData(tport, -1).sendAndTranslateMessage(player);
            } else {
                ColorTheme.sendInfoTranslation(player, "tport.command.log.logData.tportName.tportNotLogged", TPortEncapsulation.asTPort(tport));
            }
        } else if (args.length == 4) {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[2]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[2]);
                return;
            }
            if (!tport.isLogged()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.log.logData.tportName.player.tportNotLogged", TPortEncapsulation.asTPort(tport));
                return;
            }
            UUID uuid = PlayerUUID.getPlayerUUID(args[3], player);
            if (uuid == null) {
                return;
            }
            if (tport.getLogged().contains(uuid)) {
                ColorTheme.sendInfoTranslation(player, "tport.command.log.logData.tportName.player.succeeded", PlayerEncapsulation.asPlayer(uuid), TPortEncapsulation.asTPort(tport), tport.getLogMode(uuid));
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.log.logData.tportName.player.notLogged", PlayerEncapsulation.asPlayer(uuid), TPortEncapsulation.asTPort(tport));
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport log logData [TPort name] [player]");
        }
    }
}

