/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.log;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.log.Remove;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class Delete
extends SubCommand {
    public Delete() {
        EmptyCommand emptyTPort = new EmptyCommand();
        emptyTPort.setCommandName("TPort name", ArgumentType.REQUIRED);
        emptyTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.log.delete.tportName.commandDescription", new Object[0]));
        this.addAction(emptyTPort);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return TPortManager.getTPortList(player.getUniqueId()).stream().filter(TPort::isLogged).map(TPort::getName).collect(Collectors.toList());
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 3) {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[2]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[2]);
                return;
            }
            for (UUID playerUUID : tport.getLogged()) {
                String playerName = PlayerUUID.getPlayerName(playerUUID);
                Remove.run(player, tport, playerName, false);
            }
            tport.setDefaultLogMode(TPort.LogMode.NONE);
            tport.save();
            ColorTheme.sendSuccessTranslation(player, "tport.command.log.delete.tportName.succeeded", TPortEncapsulation.asTPort(tport));
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport log delete <TPort name>");
        }
    }
}

