/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.history;

import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.history.HistoryElement;
import com.spaceman.tport.history.HistoryFilter;
import com.spaceman.tport.history.TeleportHistory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class TmpName
extends SubCommand {
    public TmpName() {
        EmptyCommand emptyFilter = new EmptyCommand();
        emptyFilter.setCommandName("filter", ArgumentType.OPTIONAL);
        emptyFilter.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.history.tmpName.filter.commandDescription", new Object[0]));
        this.addAction(emptyFilter);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.history.tmpName.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        List<String> filters = HistoryFilter.getFilters();
        ArrayList<String> returnList = new ArrayList<String>();
        ArrayList history = TeleportHistory.teleportHistory.getOrDefault(player.getUniqueId(), new ArrayList());
        if (!history.isEmpty()) {
            block0: for (String filter : filters) {
                for (HistoryElement element : history) {
                    if (!HistoryFilter.fits(element, filter)) continue;
                    returnList.add(filter);
                    continue block0;
                }
            }
        }
        return returnList;
    }

    public static void run(HistoryElement element, Player player, boolean invertedSafetyCheck) {
        boolean innerSafetyCheck = element.newLocation().getSafetyCheckState(player);
        if (invertedSafetyCheck) {
            innerSafetyCheck = !innerSafetyCheck;
        }
        Location loc = element.newLocation().getLocation(player);
        if (!innerSafetyCheck || SafetyCheck.isSafe(loc)) {
            element.newLocation().teleportToLocation(player);
            TPortAdvancement.Advancement_backToTheFuture.grant(player);
        } else {
            element.newLocation().notSafeToTeleport(player);
        }
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            ArrayList history = TeleportHistory.teleportHistory.getOrDefault(player.getUniqueId(), new ArrayList());
            if (history.isEmpty()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.history.tmpName.historyEmpty", new Object[0]);
                return;
            }
            HistoryElement element = (HistoryElement)history.get(history.size() - 1);
            if (element == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.history.tmpName.historyEmpty", new Object[0]);
                return;
            }
            TmpName.run(element, player, false);
        } else if (args.length == 3) {
            String filter = HistoryFilter.exist(args[2]);
            if (filter == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.history.tmpName.filter.invalidFilter", args[2]);
                return;
            }
            ArrayList history = TeleportHistory.teleportHistory.getOrDefault(player.getUniqueId(), new ArrayList());
            if (history.isEmpty()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.history.tmpName.filter.historyEmpty", new Object[0]);
                return;
            }
            HistoryElement element = null;
            for (int i = history.size() - 1; i >= 0; --i) {
                HistoryElement historyElement = (HistoryElement)history.get(i);
                if (!HistoryFilter.fits(historyElement, filter)) continue;
                element = historyElement;
                break;
            }
            if (element == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.history.tmpName.filter.noFound", filter);
                return;
            }
            TmpName.run(element, player, false);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport history tmpName [filter]");
        }
    }
}

