/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.history;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.history.HistoryElement;
import com.spaceman.tport.history.HistoryFilter;
import com.spaceman.tport.history.TeleportHistory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.entity.Player;

public class Clear
extends SubCommand {
    public Clear() {
        EmptyCommand emptyFilter = new EmptyCommand();
        emptyFilter.setCommandName("filter", ArgumentType.OPTIONAL);
        emptyFilter.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.history.clear.filter.commandDescription", new Object[0]));
        this.addAction(emptyFilter);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.history.clear.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        List<String> filters = HistoryFilter.getFilters();
        ArrayList<String> returnList = new ArrayList<String>();
        ArrayList history = TeleportHistory.teleportHistory.getOrDefault(player.getUniqueId(), new ArrayList());
        if (!history.isEmpty()) {
            block0: for (String filter : filters) {
                for (HistoryElement element : history) {
                    if (!HistoryFilter.fits(element, filter)) continue;
                    returnList.add(filter);
                    continue block0;
                }
            }
        }
        return returnList;
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            ArrayList history = TeleportHistory.teleportHistory.getOrDefault(player.getUniqueId(), new ArrayList());
            if (history.isEmpty()) {
                ColorTheme.sendInfoTranslation(player, "tport.command.history.clear.alreadyEmpty", new Object[0]);
                return;
            }
            TeleportHistory.teleportHistory.remove(player.getUniqueId());
            ColorTheme.sendSuccessTranslation(player, "tport.command.history.clear.succeeded", history.size());
        } else if (args.length == 3) {
            String filter = HistoryFilter.exist(args[2]);
            if (filter == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.history.clear.filter.invalidFilter", args[2]);
                return;
            }
            ArrayList<HistoryElement> history = TeleportHistory.teleportHistory.getOrDefault(player.getUniqueId(), new ArrayList());
            int oldSize = history.size();
            if (history.isEmpty()) {
                ColorTheme.sendInfoTranslation(player, "tport.command.history.clear.filter.alreadyEmpty", new Object[0]);
                return;
            }
            history.removeIf(historyElement -> HistoryFilter.fits(historyElement, filter));
            int newSize = history.size();
            int cleared = oldSize - newSize;
            if (cleared == 0) {
                ColorTheme.sendSuccessTranslation(player, "tport.command.history.clear.filter.succeeded.none", cleared, filter);
            } else if (cleared == 1) {
                ColorTheme.sendSuccessTranslation(player, "tport.command.history.clear.filter.succeeded.singular", cleared, filter);
            } else {
                ColorTheme.sendSuccessTranslation(player, "tport.command.history.clear.filter.succeeded.multiple", cleared, filter);
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport history clear [filter]");
        }
    }
}

