/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.history;

import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.history.HistoryElement;
import com.spaceman.tport.history.HistoryFilter;
import com.spaceman.tport.history.TeleportHistory;
import com.spaceman.tport.tpEvents.TPEManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class Back
extends SubCommand {
    public Back() {
        EmptyCommand emptyFilter = new EmptyCommand();
        emptyFilter.setCommandName("filter", ArgumentType.OPTIONAL);
        emptyFilter.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.history.back.filter.commandDescription", new Object[0]));
        this.addAction(emptyFilter);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.history.back.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        List<String> filters = HistoryFilter.getFilters();
        ArrayList<String> returnList = new ArrayList<String>();
        ArrayList history = TeleportHistory.teleportHistory.getOrDefault(player.getUniqueId(), new ArrayList());
        if (!history.isEmpty()) {
            block0: for (String filter : filters) {
                for (HistoryElement element : history) {
                    if (!HistoryFilter.fits(element, filter)) continue;
                    returnList.add(filter);
                    continue block0;
                }
            }
        }
        return returnList;
    }

    public static void run(HistoryElement element, Player player, boolean invertedSafetyCheck) {
        boolean innerSafetyCheck = SafetyCheck.SafetyCheckSource.TPORT_BACK.getState(player);
        if (invertedSafetyCheck) {
            innerSafetyCheck = !innerSafetyCheck;
        }
        Location loc = element.oldLocation();
        if (!innerSafetyCheck || SafetyCheck.isSafe(loc)) {
            TPEManager.requestTeleportPlayer(player, loc, () -> {
                ColorTheme.sendSuccessTranslation(Bukkit.getPlayer((UUID)player.getUniqueId()), "tport.tportInventories.openHistory.teleportToOld.succeeded", new Object[0]);
                TPortAdvancement.Advancement_backToTheFuture.grant(player);
            }, (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.tportInventories.openHistory.teleportToOld.tpRequested", delay, tickMessage, seconds, secondMessage));
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.tportInventories.openHistory.teleportToOld.notSafeToTeleport", new Object[0]);
        }
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            ArrayList history = TeleportHistory.teleportHistory.getOrDefault(player.getUniqueId(), new ArrayList());
            if (history.isEmpty()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.history.back.historyEmpty", new Object[0]);
                return;
            }
            HistoryElement element = (HistoryElement)history.get(history.size() - 1);
            if (element == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.history.back.historyEmpty", new Object[0]);
                return;
            }
            Back.run(element, player, false);
        } else if (args.length == 3) {
            String filter = HistoryFilter.exist(args[2]);
            if (filter == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.history.back.filter.invalidFilter", args[2]);
                return;
            }
            ArrayList history = TeleportHistory.teleportHistory.getOrDefault(player.getUniqueId(), new ArrayList());
            if (history.isEmpty()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.history.back.filter.historyEmpty", new Object[0]);
                return;
            }
            HistoryElement element = null;
            for (int i = history.size() - 1; i >= 0; --i) {
                HistoryElement historyElement = (HistoryElement)history.get(i);
                if (!HistoryFilter.fits(historyElement, filter)) continue;
                element = historyElement;
                break;
            }
            if (element == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.history.back.filter.noFound", filter);
                return;
            }
            Back.run(element, player, false);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport history back [filter]");
        }
    }
}

