/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.edit.whitelist;

import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.entity.Player;

public class List
extends SubCommand {
    public List() {
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.whitelist.list.commandDescription", new Object[0]));
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length != 4) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport edit <TPort name> whitelist list");
            return;
        }
        TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
        if (tport == null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
            return;
        }
        ArrayList<UUID> whitelist = tport.getWhitelist();
        boolean color = true;
        Message playerList = new Message();
        for (int i = 0; i < whitelist.size(); ++i) {
            if (color) {
                playerList.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "%s", PlayerEncapsulation.asPlayer(whitelist.get(i))));
            } else {
                playerList.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfo2Color, ColorTheme.ColorType.varInfo2Color, "%s", PlayerEncapsulation.asPlayer(whitelist.get(i))));
            }
            if (i + 2 == whitelist.size()) {
                playerList.addMessage(ColorTheme.formatInfoTranslation("tport.command.edit.whitelist.list.succeeded.lastDelimiter", new Object[0]));
            } else {
                playerList.addMessage(ColorTheme.formatInfoTranslation("tport.command.edit.whitelist.list.succeeded.delimiter", new Object[0]));
            }
            color = !color;
        }
        playerList.removeLast();
        if (whitelist.isEmpty()) {
            ColorTheme.sendInfoTranslation(player, "tport.command.edit.whitelist.list.succeeded.empty", tport);
        } else if (whitelist.size() == 1) {
            ColorTheme.sendInfoTranslation(player, "tport.command.edit.whitelist.list.succeeded.singular", tport, playerList);
        } else {
            ColorTheme.sendInfoTranslation(player, "tport.command.edit.whitelist.list.succeeded.multiple", tport, playerList);
        }
    }
}

