/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.edit.whitelist;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class Clone
extends SubCommand {
    private final EmptyCommand emptyTPort = new EmptyCommand();

    public Clone() {
        this.emptyTPort.setCommandName("TPort name", ArgumentType.REQUIRED);
        this.emptyTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.whitelist.clone.commandDescription", new Object[0]));
        this.emptyTPort.setPermissions("TPort.edit.whitelist.clone", "TPort.basic");
        this.addAction(this.emptyTPort);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptyTPort.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return TPortManager.getTPortList(player.getUniqueId()).stream().map(TPort::getName).collect(Collectors.toList());
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length != 5) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport edit <TPort name> whitelist clone <TPort name>");
            return;
        }
        if (!this.emptyTPort.hasPermissionToRun(player, true)) {
            return;
        }
        TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
        if (tport == null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
            return;
        }
        TPort cloneTPort = TPortManager.getTPort(player.getUniqueId(), args[4]);
        if (cloneTPort == null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
            return;
        }
        tport.setWhitelist(new ArrayList<UUID>(cloneTPort.getWhitelist()));
        tport.save();
        ColorTheme.sendSuccessTranslation(player, "tport.command.edit.whitelist.clone.succeeded", cloneTPort, tport);
    }
}

