/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.edit.whitelist;

import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Add
extends SubCommand {
    private final EmptyCommand emptyPlayer = new EmptyCommand();

    public Add() {
        this.emptyPlayer.setCommandName("player", ArgumentType.REQUIRED);
        this.emptyPlayer.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.whitelist.add.commandDescription", new Object[0]));
        this.emptyPlayer.setTabRunnable((args, player) -> {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport != null) {
                ArrayList<String> list = PlayerUUID.getPlayerNames();
                list.remove(player.getName());
                tport.getWhitelist().stream().map(PlayerUUID::getPlayerName).filter(Objects::nonNull).forEach(list::remove);
                list.removeAll(Arrays.asList(args).subList(4, args.length));
                return list;
            }
            return new ArrayList();
        });
        this.emptyPlayer.setLooped(true);
        this.emptyPlayer.setPermissions("TPort.edit.whitelist.add", "TPort.basic");
        this.addAction(this.emptyPlayer);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptyPlayer.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return this.emptyPlayer.tabList(player, args);
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length <= 4) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport edit <TPort name> whitelist add <player...>");
            return;
        }
        if (!this.emptyPlayer.hasPermissionToRun(player, true)) {
            return;
        }
        TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
        if (tport == null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
            return;
        }
        if (tport.isOffered()) {
            ColorTheme.sendErrorTranslation(player, "tport.command.edit.whitelist.add.isOffered", tport, PlayerEncapsulation.asPlayer(tport.getOfferedTo()));
            return;
        }
        for (int i = 4; i < args.length; ++i) {
            String newPlayerName = args[i];
            UUID newPlayerUUID = PlayerUUID.getPlayerUUID(newPlayerName, player);
            if (newPlayerUUID == null) continue;
            if (newPlayerUUID.equals(player.getUniqueId())) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.whitelist.add.addYourself", new Object[0]);
                continue;
            }
            Player newPlayer = Bukkit.getPlayer((UUID)newPlayerUUID);
            if (tport.addWhitelist(newPlayerUUID)) {
                ColorTheme.sendSuccessTranslation(player, "tport.command.edit.whitelist.add.succeeded", PlayerEncapsulation.asPlayer(newPlayer, newPlayerUUID), tport);
                ColorTheme.sendInfoTranslation(newPlayer, "tport.command.edit.whitelist.add.succeededOtherPlayer", player, tport);
                TPortAdvancement.Advancement_safetyFirst.grant(player);
                continue;
            }
            ColorTheme.sendErrorTranslation(player, "tport.command.edit.whitelist.add.alreadyInList", PlayerEncapsulation.asPlayer(newPlayer, newPlayerUUID), tport);
        }
        tport.save();
    }
}

