/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.edit.waypoint;

import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.colorTheme.MultiColor;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class Color
extends SubCommand {
    public Color() {
        EmptyCommand emptySetTypeChat = new EmptyCommand();
        emptySetTypeChat.setCommandName("chat color", ArgumentType.REQUIRED);
        emptySetTypeChat.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.waypoint.color.color.chat.commandDescription", new Object[0]));
        EmptyCommand emptySetTypeHex = new EmptyCommand();
        emptySetTypeHex.setCommandName("hex color", ArgumentType.REQUIRED);
        emptySetTypeHex.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.waypoint.color.color.hex.commandDescription", new Object[0]));
        this.addAction(emptySetTypeChat);
        this.addAction(emptySetTypeHex);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (args[4].startsWith("#")) {
            return args[4].length() < 8 ? Collections.singletonList(args[4] + "#ffffff".substring(args[4].length(), 7)) : Collections.singletonList(args[4].substring(0, 7));
        }
        List<String> list = Arrays.stream(ChatColor.values()).map(Enum::name).collect(Collectors.toList());
        list.add("#ffffff");
        list.add("#000000");
        list.add("#");
        return list;
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 4) {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
                return;
            }
            Message thisMessage = ColorTheme.formatTranslation(tport.getWaypointColor(), tport.getWaypointColor(), "tport.command.edit.waypoint.color.this", new Object[0]);
            thisMessage.getText().forEach(t -> t.setInsertion(tport.getWaypointColor().getColorAsValue()));
            ColorTheme.sendInfoTranslation(player, "tport.command.edit.waypoint.color.succeeded", TPortEncapsulation.asTPort(tport), thisMessage);
        } else if (args.length == 5) {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
                return;
            }
            if (tport.isOffered()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.waypoint.color.color.isOffered", tport, PlayerEncapsulation.asPlayer(tport.getOfferedTo()));
                return;
            }
            if (Arrays.stream(ChatColor.values()).map(Enum::name).anyMatch(c -> c.equalsIgnoreCase(args[4]))) {
                tport.setWaypointColor(new MultiColor(ChatColor.valueOf((String)args[4].toUpperCase())));
                tport.save();
                Message thisMessage = ColorTheme.formatTranslation(tport.getWaypointColor(), tport.getWaypointColor(), "tport.command.edit.waypoint.color.color.this", new Object[0]);
                thisMessage.getText().forEach(t -> t.setInsertion(tport.getWaypointColor().getColorAsValue()));
                ColorTheme.sendSuccessTranslation(player, "tport.command.edit.waypoint.color.color.chat.this", TPortEncapsulation.asTPort(tport), thisMessage);
                TPortAdvancement.Advancement_PrettyColors.grant(player);
            } else if (args[4].matches("#[0-9a-fA-F]{6}")) {
                tport.setWaypointColor(new MultiColor(args[4]));
                tport.save();
                Message thisMessage = ColorTheme.formatTranslation(tport.getWaypointColor(), tport.getWaypointColor(), "tport.command.edit.waypoint.color.color.this", new Object[0]);
                thisMessage.getText().forEach(t -> t.setInsertion(tport.getWaypointColor().getColorAsValue()));
                ColorTheme.sendSuccessTranslation(player, "tport.command.edit.waypoint.color.color.hex.this", TPortEncapsulation.asTPort(tport), thisMessage);
                TPortAdvancement.Advancement_PrettyColors.grant(player);
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.colorTheme.set.type.colorNotFound", args[4]);
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport edit <TPort name> waypoint color [chat color|hex color]");
        }
    }
}

