/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.edit.dynmap;

import com.spaceman.tport.Main;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.bukkit.entity.Player;

public class Show
extends SubCommand {
    private final EmptyCommand emptyState = new EmptyCommand();

    public Show() {
        this.emptyState.setCommandName("state", ArgumentType.OPTIONAL);
        this.emptyState.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.dynmap.show.state.commandDescription", new Object[0]));
        this.emptyState.setPermissions("TPort.edit.dynmap.setShow", "TPort.basic");
        this.addAction(this.emptyState);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.dynmap.show.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptyState.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Arrays.asList("true", "false");
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 4) {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
                return;
            }
            ColorTheme.sendInfoTranslation(player, "tport.command.edit.dynmap.show.succeeded", TPortEncapsulation.asTPort(tport), ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "tport.command.edit.dynmap." + (tport.showOnDynmap() ? "shown" : "hidden"), new Object[0]));
        } else if (args.length == 5) {
            if (!this.emptyState.hasPermissionToRun(player, true)) {
                return;
            }
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
                return;
            }
            if (tport.isOffered()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.dynmap.show.state.isOffered", TPortEncapsulation.asTPort(tport), PlayerEncapsulation.asPlayer(tport.getOfferedTo()));
                return;
            }
            Boolean show = Main.toBoolean(args[4]);
            if (show == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport edit <TPort name> dynmap show [true|false]");
                return;
            }
            tport.showOnDynmap(show);
            tport.save();
            ColorTheme.sendInfoTranslation(player, "tport.command.edit.dynmap.show.state.succeeded", TPortEncapsulation.asTPort(tport), ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "tport.command.edit.dynmap." + (tport.showOnDynmap() ? "shown" : "hidden"), new Object[0]));
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport edit <TPort name> dynmap show [state]");
        }
    }
}

