/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.edit.dynmap;

import com.spaceman.tport.Main;
import com.spaceman.tport.Pair;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import com.spaceman.tport.webMaps.DynmapHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class Icon
extends SubCommand {
    private final EmptyCommand emptyIcon = new EmptyCommand();

    public Icon() {
        this.emptyIcon.setCommandName("icon", ArgumentType.OPTIONAL);
        this.emptyIcon.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.dynmap.icon.icon.commandDescription", new Object[0]));
        this.emptyIcon.setPermissions("TPort.edit.dynmap.setIcon", "TPort.basic");
        this.addAction(this.emptyIcon);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.dynmap.icon.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptyIcon.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return ((List)Main.getOrDefault(DynmapHandler.getIcons(), new ArrayList())).stream().map(Pair::getRight).collect(Collectors.toList());
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 4) {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
                return;
            }
            ColorTheme.sendInfoTranslation(player, "tport.command.edit.dynmap.icon.succeeded", TPortEncapsulation.asTPort(tport), DynmapHandler.getTPortIconName(tport));
        } else if (args.length == 5) {
            if (!this.emptyIcon.hasPermissionToRun(player, true)) {
                return;
            }
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
                return;
            }
            if (tport.isOffered()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.dynmap.icon.icon.isOffered", TPortEncapsulation.asTPort(tport), PlayerEncapsulation.asPlayer(tport.getOfferedTo()));
                return;
            }
            String id = DynmapHandler.iconLabelToID(args[4]);
            if (id == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.dynmap.icon.icon.iconNotFound", args[4]);
                return;
            }
            tport.setDynmapIconID(id);
            tport.save();
            ColorTheme.sendSuccessTranslation(player, "tport.command.edit.dynmap.icon.icon.succeeded", TPortEncapsulation.asTPort(tport), DynmapHandler.getTPortIconName(tport));
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport edit <TPort name> dynmap show [state]");
        }
    }
}

