/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.edit.blueMap;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import com.spaceman.tport.webMaps.BlueMapHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.bukkit.entity.Player;

public class Icon
extends SubCommand {
    private final EmptyCommand emptyIcon = new EmptyCommand();

    public Icon() {
        this.emptyIcon.setCommandName("icon", ArgumentType.OPTIONAL);
        this.emptyIcon.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.blueMap.icon.icon.commandDescription", new Object[0]));
        this.emptyIcon.setPermissions("TPort.edit.blueMap.setIcon", "TPort.basic");
        this.addAction(this.emptyIcon);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.blueMap.icon.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptyIcon.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        try {
            return BlueMapHandler.getBlueMapImages();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 4) {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
                return;
            }
            String tportIcon = null;
            try {
                tportIcon = BlueMapHandler.getTPortIconName(tport);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ColorTheme.sendInfoTranslation(player, "tport.command.edit.blueMap.icon.succeeded", TPortEncapsulation.asTPort(tport), tportIcon);
        } else if (args.length == 5) {
            ArrayList<String> images;
            if (!this.emptyIcon.hasPermissionToRun(player, true)) {
                return;
            }
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
                return;
            }
            if (tport.isOffered()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.blueMap.icon.icon.isOffered", TPortEncapsulation.asTPort(tport), PlayerEncapsulation.asPlayer(tport.getOfferedTo()));
                return;
            }
            try {
                images = BlueMapHandler.getBlueMapImages();
            }
            catch (Exception e) {
                images = new ArrayList();
            }
            if (!images.contains(args[4])) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.blueMap.icon.icon.iconNotFound", args[4]);
                return;
            }
            tport.setBlueMapIcon(args[4]);
            tport.save();
            ColorTheme.sendSuccessTranslation(player, "tport.command.edit.blueMap.icon.icon.succeeded", tport, args[4]);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport edit <TPort name> blueMap show [state]");
        }
    }
}

