/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.edit;

import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import org.bukkit.entity.Player;

public class Range
extends SubCommand {
    private final EmptyCommand emptyRange = new EmptyCommand();

    public Range() {
        this.emptyRange.setCommandName("range", ArgumentType.OPTIONAL);
        this.emptyRange.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.range.range.commandDescription", "0"));
        this.emptyRange.setPermissions("TPort.edit.range", "TPort.basic");
        this.addAction(this.emptyRange);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.range.commandDescription", new Object[0]));
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 3) {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
                return;
            }
            if (tport.hasRange()) {
                ColorTheme.sendInfoTranslation(player, "tport.command.edit.range.succeededRange", TPortEncapsulation.asTPort(tport), String.valueOf(tport.getRange()));
            } else {
                ColorTheme.sendInfoTranslation(player, "tport.command.edit.range.succeededNoRange", TPortEncapsulation.asTPort(tport), ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.edit.range.off", new Object[0]));
            }
        } else if (args.length == 4) {
            int range;
            if (!this.emptyRange.hasPermissionToRun(player, true)) {
                return;
            }
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
                return;
            }
            if (tport.isOffered()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.range.range.isOffered", TPortEncapsulation.asTPort(tport), PlayerEncapsulation.asPlayer(tport.getOfferedTo()));
                return;
            }
            try {
                range = Integer.parseInt(args[3]);
            }
            catch (NumberFormatException nfe) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.range.range.notANumber", args[3]);
                return;
            }
            tport.setRange(range);
            tport.save();
            if (range == 0) {
                ColorTheme.sendSuccessTranslation(player, "tport.command.edit.range.range.succeededNoRange", TPortEncapsulation.asTPort(tport), ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.edit.range.off", new Object[0]));
            } else {
                ColorTheme.sendSuccessTranslation(player, "tport.command.edit.range.range.succeededRange", TPortEncapsulation.asTPort(tport), String.valueOf(range));
            }
            TPortAdvancement.Advancement_safetyFirst.grant(player);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport edit <TPort name> range [range]");
        }
    }
}

