/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.edit;

import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class Private
extends SubCommand {
    private final EmptyCommand emptyState = new EmptyCommand();

    private Message getEmptyStateCommandDescription() {
        Message message = ColorTheme.formatInfoTranslation("tport.command.edit.private.state.commandDescription", new Object[0]);
        for (TPort.PrivateState privateState : TPort.PrivateState.values()) {
            message.addText(TextComponent.textComponent("\n"));
            message.addMessage(privateState.getDescription());
        }
        return message;
    }

    public Private() {
        this.emptyState.setCommandName("state", ArgumentType.OPTIONAL);
        this.emptyState.setCommandDescription(this.getEmptyStateCommandDescription());
        this.emptyState.setPermissions("TPort.edit.private", "TPort.basic");
        this.addAction(this.emptyState);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.edit.private.commandDescription", new Object[0]));
    }

    public List<String> tabList(Player player, String[] args) {
        if (!this.emptyState.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Arrays.stream(TPort.PrivateState.values()).map(s -> s.name().toLowerCase()).collect(Collectors.toList());
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 3) {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
                return;
            }
            Message hereMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.edit.private.here", new Object[0]);
            hereMessage.getText().forEach(text -> text.setInsertion("/tport help tport edit <tport name> private <state>").addTextEvent(HoverEvent.hoverEvent(TextComponent.textComponent("/tport help tport edit <tport name> private <state>", ColorTheme.ColorType.infoColor))).addTextEvent(ClickEvent.runCommand("/tport help tport edit <tport name> private <state>")));
            ColorTheme.sendInfoTranslation(player, "tport.command.edit.private.succeeded", TPortEncapsulation.asTPort(tport), tport.getPrivateState(), hereMessage);
        } else if (args.length == 4) {
            if (!this.emptyState.hasPermissionToRun(player, true)) {
                return;
            }
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[1]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[1]);
                return;
            }
            if (tport.isOffered()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.private.state.isOffered", TPortEncapsulation.asTPort(tport), PlayerEncapsulation.asPlayer(tport.getOfferedTo()));
                return;
            }
            TPort.PrivateState ps = TPort.PrivateState.get(args[3], null);
            if (ps == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.private.state.stateNotFound", args[3]);
                return;
            }
            if (tport.isPublicTPort() && !ps.canGoPublic()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.edit.private.state.isPublic", TPortEncapsulation.asTPort(tport), ps);
                return;
            }
            tport.setPrivateState(ps);
            tport.save();
            ColorTheme.sendSuccessTranslation(player, "tport.command.edit.private.state.succeeded", TPortEncapsulation.asTPort(tport), ps);
            TPortAdvancement.Advancement_safetyFirst.grant(player);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport edit <TPort name> private [state]");
        }
    }
}

