/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.dynmap;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.webMaps.DynmapHandler;
import java.util.Collection;
import org.bukkit.entity.Player;

public class Colors
extends SubCommand {
    private final EmptyCommand colorTheme = new EmptyCommand();

    public Colors() {
        this.colorTheme.setCommandName("color theme", ArgumentType.OPTIONAL);
        this.colorTheme.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.dynmapCommand.colors.colorTheme.commandDescription", new Object[0]));
        this.colorTheme.setPermissions("TPort.dynmap.colors", "TPort.admin.dynmap");
        this.addAction(this.colorTheme);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.dynmapCommand.colors.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return ColorTheme.getDefaultThemes();
    }

    public static String getDynmapThemeName() {
        return Files.tportConfig.getConfig().getString("dynmap.colors", "developerTheme");
    }

    public static ColorTheme getDynmapTheme() {
        return ColorTheme.getDefaultTheme(Colors.getDynmapThemeName());
    }

    public static void setDynmapTheme(String theme) {
        if (ColorTheme.getDefaultThemes().contains(theme)) {
            Files.tportConfig.getConfig().set("dynmap.colors", (Object)theme);
            Files.tportConfig.saveConfig();
            DynmapHandler.updateAllTPorts();
        }
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            String dynmapThemeName = Colors.getDynmapThemeName();
            ColorTheme.sendInfoTranslation(player, "tport.command.dynmapCommand.colors.succeeded", dynmapThemeName);
        } else if (args.length == 3) {
            if (!this.colorTheme.hasPermissionToRun(player, true)) {
                return;
            }
            if (ColorTheme.getDefaultThemesMap().containsKey(args[2])) {
                Colors.setDynmapTheme(args[2]);
                ColorTheme.sendSuccessTranslation(player, "tport.command.dynmapCommand.colors.colorTheme.succeeded", args[2]);
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.dynmapCommand.colors.colorTheme.themeNotFound", args[2]);
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport dynmap colors [colorTheme]");
        }
    }
}

