/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.delay;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Delay;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.bukkit.entity.Player;

public class Handler
extends SubCommand {
    private final EmptyCommand emptyHandlerState = new EmptyCommand();

    public Handler() {
        this.emptyHandlerState.setCommandName("state", ArgumentType.OPTIONAL);
        this.emptyHandlerState.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.delay.handler.state.commandDescription", "true", "TPort.delay.time.<time in minecraft ticks>"));
        this.emptyHandlerState.setPermissions("TPort.delay.handler.set", "TPort.admin.delay");
        this.addAction(this.emptyHandlerState);
        this.setPermissions("TPort.delay.handler.get", "TPort.admin.delay");
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.delay.handler.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (this.emptyHandlerState.hasPermissionToRun(player, false)) {
            return Arrays.asList("permissions", "command");
        }
        return Collections.emptyList();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            if (!this.hasPermissionToRun(player, true)) {
                return;
            }
            if (Delay.isPermissionBased()) {
                Message stateMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.delay.type.permissions", new Object[0]);
                ColorTheme.sendInfoTranslation(player, "tport.command.delay.handler.succeeded", stateMessage);
                ColorTheme.sendInfoTranslation(player, "tport.command.delay.handler.permission", "TPort.delay.time.<time in minecraft ticks>");
            } else {
                Message stateMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.delay.type.command", new Object[0]);
                ColorTheme.sendInfoTranslation(player, "tport.command.delay.handler.succeeded", stateMessage);
            }
        } else if (args.length == 3) {
            boolean state;
            if (!this.emptyHandlerState.hasPermissionToRun(player, true)) {
                return;
            }
            if (args[2].equalsIgnoreCase("permissions")) {
                state = true;
            } else if (args[2].equalsIgnoreCase("command")) {
                state = false;
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport delay handler [permissions|command]");
                return;
            }
            Delay.setPermissionBased(state);
            Message stateMessage = state ? ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.delay.type.permissions", new Object[0]) : ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.delay.type.command", new Object[0]);
            ColorTheme.sendSuccessTranslation(player, "tport.command.delay.handler.state.succeeded", stateMessage);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport delay handler [state]");
        }
    }
}

