/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.delay;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Delay;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.playerUUID.PlayerUUID;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Get
extends SubCommand {
    private final EmptyCommand emptyPlayer = new EmptyCommand();

    public Get() {
        this.emptyPlayer.setCommandName("player", ArgumentType.OPTIONAL);
        this.emptyPlayer.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.delay.get.player.commandDescription", new Object[0]));
        this.emptyPlayer.setPermissions("TPort.delay.get.all", "TPort.admin.delay");
        this.addAction(this.emptyPlayer);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.delay.get.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptyPlayer.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Delay.isPermissionBased() ? (Collection)Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()) : PlayerUUID.getPlayerNames();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            int delay = Delay.delayTime(player);
            double seconds = (double)delay / 20.0;
            Message secondMessage = seconds == 1.0 ? ColorTheme.formatSuccessTranslation("tport.command.second", new Object[0]) : ColorTheme.formatSuccessTranslation("tport.command.seconds", new Object[0]);
            Message tickMessage = delay == 1 ? ColorTheme.formatSuccessTranslation("tport.command.minecraftTick", new Object[0]) : ColorTheme.formatSuccessTranslation("tport.command.minecraftTicks", new Object[0]);
            ColorTheme.sendInfoTranslation(player, "tport.command.delay.get.player.succeeded", PlayerEncapsulation.asPlayer(player), delay, tickMessage, seconds, secondMessage);
        } else if (args.length == 3) {
            int delay;
            if (!this.emptyPlayer.hasPermissionToRun(player, true)) {
                return;
            }
            UUID newUUID = PlayerUUID.getPlayerUUID(args[2], player);
            if (newUUID == null) {
                return;
            }
            Player newPlayer = null;
            if (Delay.isPermissionBased()) {
                newPlayer = Bukkit.getPlayer((UUID)newUUID);
                if (newPlayer == null) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.playerNotOnline", PlayerEncapsulation.asPlayer(newUUID));
                    return;
                }
                delay = Delay.delayTime(newPlayer);
            } else {
                delay = Delay.delayTime(newUUID);
            }
            double seconds = (double)delay / 20.0;
            Message secondMessage = seconds == 1.0 ? ColorTheme.formatSuccessTranslation("tport.command.second", new Object[0]) : ColorTheme.formatSuccessTranslation("tport.command.seconds", new Object[0]);
            Message tickMessage = delay == 1 ? ColorTheme.formatSuccessTranslation("tport.command.minecraftTick", new Object[0]) : ColorTheme.formatSuccessTranslation("tport.command.minecraftTicks", new Object[0]);
            ColorTheme.sendInfoTranslation(player, "tport.command.delay.get.player.succeeded", PlayerEncapsulation.asPlayer(newPlayer, newUUID), delay, tickMessage, seconds, secondMessage);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport delay get [player]");
        }
    }
}

