/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.blueMap;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.blueMap.IP;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class Search
extends SubCommand {
    private final EmptyCommand emptyPlayerTPort = new EmptyCommand();

    public Search() {
        this.emptyPlayerTPort.setCommandName("TPort name", ArgumentType.OPTIONAL);
        this.emptyPlayerTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.blueMapCommand.search.player.tport.commandDescription", new Object[]{ColorTheme.ColorType.infoColor}));
        this.emptyPlayerTPort.setPermissions("TPort.blueMap.search", "TPort.basic");
        EmptyCommand emptyPlayer = new EmptyCommand();
        emptyPlayer.setCommandName("player", ArgumentType.REQUIRED);
        emptyPlayer.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.blueMapCommand.search.player.commandDescription", new Object[]{ColorTheme.ColorType.infoColor}));
        emptyPlayer.setPermissions(this.emptyPlayerTPort.getPermissions());
        emptyPlayer.setTabRunnable((args, player) -> {
            if (this.emptyPlayerTPort.hasPermissionToRun(player, false)) {
                return Collections.emptyList();
            }
            UUID argOneUUID = PlayerUUID.getPlayerUUID(args[2]);
            if (argOneUUID == null) {
                return Collections.emptyList();
            }
            ArrayList<String> list = new ArrayList<String>();
            for (TPort tport : TPortManager.getTPortList(argOneUUID)) {
                Boolean access = tport.hasAccess(player);
                if (access != null && !access.booleanValue()) continue;
                list.add(tport.getName());
            }
            return list;
        });
        emptyPlayer.addAction(this.emptyPlayerTPort);
        this.addAction(emptyPlayer);
    }

    public List<String> tabList(Player player, String[] args) {
        if (!this.emptyPlayerTPort.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return PlayerUUID.getPlayerNames();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 3) {
            if (!this.emptyPlayerTPort.hasPermissionToRun(player, true)) {
                return;
            }
            String ip = IP.getIP();
            if (ip == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.blueMapCommand.search.player.ipNotSet", "/tport blueMap IP <IP>");
                return;
            }
            String newPlayerName = args[2];
            UUID newPlayerUUID = PlayerUUID.getPlayerUUID(newPlayerName, player);
            if (newPlayerUUID == null) {
                return;
            }
            Player newPlayer = Bukkit.getPlayer((UUID)newPlayerUUID);
            if (newPlayer == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.playerNotOnline", PlayerEncapsulation.asPlayer(newPlayerUUID));
                return;
            }
            Location location = newPlayer.getLocation();
            String url = ip + String.format("#%s:%s:%s:%s:5:0:0:0:0:flat", location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Message message = ColorTheme.formatInfoTranslation("tport.command.blueMapCommand.search.player.succeeded", PlayerEncapsulation.asPlayer(newPlayer));
            message.getText().forEach(textComponent -> textComponent.setInsertion(url).addTextEvent(HoverEvent.hoverEvent(TextComponent.textComponent(url, ColorTheme.ColorType.infoColor))).addTextEvent(ClickEvent.openUrl(url)));
            message.sendAndTranslateMessage(player);
        } else if (args.length == 4) {
            if (!this.emptyPlayerTPort.hasPermissionToRun(player, true)) {
                return;
            }
            String ip = IP.getIP();
            if (ip == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.blueMapCommand.search.player.ipNotSet", "/tport blueMap IP <IP>");
                return;
            }
            String newPlayerName = args[2];
            UUID newPlayerUUID = PlayerUUID.getPlayerUUID(newPlayerName, player);
            if (newPlayerUUID == null) {
                return;
            }
            TPort tport = TPortManager.getTPort(newPlayerUUID, args[3]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[3]);
                return;
            }
            Location location = tport.getLocation();
            String url = ip + String.format("#%s:%s:%s:%s:5:0:0:0:0:flat", location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Message message = ColorTheme.formatInfoTranslation("tport.command.blueMapCommand.search.player.tport.succeeded", TPortEncapsulation.asTPort(tport));
            message.getText().forEach(textComponent -> textComponent.setInsertion(url).addTextEvent(HoverEvent.hoverEvent(TextComponent.textComponent(url, ColorTheme.ColorType.infoColor))).addTextEvent(ClickEvent.openUrl(url)));
            message.sendAndTranslateMessage(player);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport blueMap search <player> [TPort name]");
        }
    }
}

