/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.biomeTP;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.BiomeTP;
import com.spaceman.tport.commands.tport.biomeTP.Mode;
import com.spaceman.tport.cooldown.CooldownManager;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.BiomeEncapsulation;
import com.spaceman.tport.permissions.PermissionHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;

public class Whitelist
extends SubCommand {
    public Whitelist() {
        EmptyCommand emptyWhitelist = new EmptyCommand();
        emptyWhitelist.setCommandName("biome", ArgumentType.REQUIRED);
        emptyWhitelist.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.biomeTP.whitelist.biome.commandDescription", new Object[0]));
        emptyWhitelist.setTabRunnable((args, player) -> {
            if (!PermissionHandler.hasPermission(player, false, true, "TPort.biomeTP.whitelist")) {
                return Collections.emptyList();
            }
            List<String> biomeList = Arrays.asList(args).subList(2, args.length).stream().map(String::toLowerCase).toList();
            return BiomeTP.availableBiomes(player.getWorld()).stream().filter(name -> biomeList.stream().noneMatch(name::equals)).toList();
        });
        emptyWhitelist.setLooped(true);
        emptyWhitelist.setPermissions("TPort.biomeTP.whitelist", "TPort.biomeTP.biome.<biome...>");
        emptyWhitelist.permissionsOR(false);
        this.addAction(emptyWhitelist);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!PermissionHandler.hasPermission(player, false, true, "TPort.biomeTP.whitelist")) {
            return Collections.emptyList();
        }
        List<String> biomeList = Arrays.asList(args).subList(2, args.length).stream().map(String::toLowerCase).toList();
        return BiomeTP.availableBiomes(player.getWorld()).stream().filter(name -> biomeList.stream().noneMatch(name::equals)).toList();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport biomeTP whitelist <biome...>");
        } else {
            if (!PermissionHandler.hasPermission(player, true, true, "TPort.biomeTP.whitelist")) {
                return;
            }
            if (!CooldownManager.BiomeTP.hasCooled(player)) {
                return;
            }
            List<String> possibleBiomes = BiomeTP.availableBiomes(player.getWorld());
            ArrayList<String> whitelist = new ArrayList<String>();
            for (int i = 2; i < args.length; ++i) {
                String biomeName = args[i].toLowerCase();
                if (biomeName.startsWith("minecraft:")) {
                    biomeName = biomeName.substring(10);
                }
                if (!possibleBiomes.contains(biomeName)) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.biomeTP.whitelist.biome.worldNotGenerateBiome", biomeName);
                    continue;
                }
                if (!PermissionHandler.hasPermission(player, true, true, "TPort.biomeTP.biome." + biomeName)) continue;
                if (whitelist.contains(biomeName)) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.biomeTP.blacklist.biome.biomeAlreadyInList", new BiomeEncapsulation(biomeName));
                    continue;
                }
                whitelist.add(biomeName);
            }
            if (whitelist.isEmpty()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.biomeTP.whitelist.biome.noBiomesLeft", new Object[0]);
                return;
            }
            BiomeTP.biomeTP(player, Mode.getDefMode(player.getUniqueId()), whitelist);
        }
    }
}

