/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.biomeTP;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.featureTP.Mode;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.permissions.PermissionHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class Mode
extends SubCommand {
    public Mode() {
        EmptyCommand emptyModeMode = new EmptyCommand();
        emptyModeMode.setCommandName("mode", ArgumentType.OPTIONAL);
        emptyModeMode.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.biomeTP.mode.mode.commandDescription", new Object[0]));
        emptyModeMode.setPermissions(com.spaceman.tport.commands.tport.featureTP.Mode.worldSearchString);
        this.addAction(emptyModeMode);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.biomeTP.mode.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return Arrays.stream(Mode.WorldSearchMode.values()).map(Enum::name).collect(Collectors.toList());
    }

    public static Mode.WorldSearchMode getDefMode(UUID uuid) {
        return Mode.WorldSearchMode.valueOf(Files.tportConfig.getConfig().getString("biomeTP.defaultMode." + uuid.toString(), "CLOSEST"));
    }

    public static void setDefMode(UUID uuid, Mode.WorldSearchMode mode) {
        Files.tportConfig.getConfig().set("biomeTP.defaultMode." + uuid.toString(), (Object)mode.name());
        Files.tportConfig.saveConfig();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            ColorTheme.sendInfoTranslation(player, "tport.command.biomeTP.mode.succeeded", Mode.getDefMode(player.getUniqueId()).name());
        } else if (args.length == 3) {
            try {
                Mode.WorldSearchMode mode = Mode.WorldSearchMode.valueOf(args[2].toUpperCase());
                if (!PermissionHandler.hasPermission(player, true, mode.getPerm())) {
                    return;
                }
                Mode.setDefMode(player.getUniqueId(), mode);
                ColorTheme.sendSuccessTranslation(player, "tport.command.biomeTP.mode.mode.succeeded", mode.name());
            }
            catch (IllegalArgumentException iae) {
                ColorTheme.sendErrorTranslation(player, "tport.command.biomeTP.mode.mode.modeNotExist", args[2]);
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport biomeTP mode [mode]");
        }
    }
}

