/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.backup;

import com.spaceman.tport.Main;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.bukkit.entity.Player;

public class Auto
extends SubCommand {
    private final EmptyCommand emptyCount = new EmptyCommand();

    public Auto() {
        this.emptyCount.setCommandName("count", ArgumentType.OPTIONAL);
        this.emptyCount.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.backup.auto.count.commandDescription", new Object[0]));
        this.emptyCount.setPermissions("TPort.admin.backup.auto");
        EmptyCommand emptyState = new EmptyCommand();
        emptyState.setCommandName("state", ArgumentType.OPTIONAL);
        emptyState.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.backup.auto.state.commandDescription", new Object[0]));
        emptyState.setPermissions(this.emptyCount.getPermissions());
        this.addAction(emptyState);
        this.addAction(this.emptyCount);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.backup.auto.commandDescription", new Object[0]));
    }

    public static String getBackupName() {
        return new SimpleDateFormat("dd-MMM-yyyy-hh_mm_ss").format(Calendar.getInstance().getTime());
    }

    private static void removeRedundant() {
        File dir = new File(Main.getInstance().getDataFolder(), "backup");
        if (!dir.mkdir()) {
            ArrayList<File> files = new ArrayList<File>();
            for (File f : dir.listFiles()) {
                if (!f.getName().startsWith("auto-")) continue;
                files.add(f);
            }
            files.sort(Comparator.comparingLong(File::lastModified));
            int count = Auto.getBackupCount();
            if (files.size() >= count) {
                for (int i = 0; i <= files.size() - count; ++i) {
                    try {
                        if (((File)files.get(i)).delete()) continue;
                        Main.getInstance().getLogger().warning("Could not delete redundant backup " + ((File)files.get(i)).getName());
                        continue;
                    }
                    catch (SecurityException se) {
                        Main.getInstance().getLogger().warning("Could not delete redundant backup " + ((File)files.get(i)).getName());
                    }
                }
            }
        }
    }

    public static void save() {
        if (Auto.getBackupState()) {
            Auto.removeRedundant();
            Auto.save("auto-" + Auto.getBackupName(), null);
        }
    }

    public static void save(String backupName, Player player) {
        if (Auto.getBackupState()) {
            if (Main.containsSpecialCharacter(backupName)) {
                ColorTheme.sendErrorTranslation(player, "tport.command.backup.save.name.error.specialChars", "A-Z", "0-9", "-", "_");
                return;
            }
            int version = 0;
            while (true) {
                Object suffix = "";
                if (version != 0) {
                    suffix = "(" + version + ")";
                }
                File file = new File(new File(Main.getInstance().getDataFolder(), "backup"), backupName + (String)suffix + ".yml");
                try {
                    if (file.createNewFile()) {
                        Files configFile = new Files(Main.getInstance(), "backup", backupName + (String)suffix + ".yml");
                        configFile.getConfig().set("tport", (Object)Files.tportData.getConfig().getConfigurationSection("tport"));
                        configFile.getConfig().set("public", (Object)Files.tportData.getConfig().getConfigurationSection("public"));
                        configFile.saveConfig();
                        ColorTheme.sendSuccessTranslation(player, "tport.command.backup.save.name.succeeded", file.getName());
                        if (player == null) {
                            Main.getInstance().getLogger().info("Auto save backup " + backupName + " succeeded");
                        } else {
                            Main.getInstance().getLogger().info("Save backup " + backupName + " succeeded");
                        }
                        return;
                    }
                    ++version;
                }
                catch (IOException e) {
                    if (Features.Feature.PrintErrorsInConsole.isEnabled()) {
                        e.printStackTrace();
                    }
                    if (player == null) {
                        Main.getInstance().getLogger().warning("Could not auto save backup file " + backupName + ": " + e.getMessage());
                    } else {
                        Main.getInstance().getLogger().warning("Could not save backup file " + backupName + ": " + e.getMessage());
                    }
                    ColorTheme.sendErrorTranslation(player, "tport.command.backup.save.name.error", e.getMessage());
                    return;
                }
            }
        }
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return this.emptyCount.hasPermissionToRun(player, false) ? Arrays.asList("true", "false", "<count>") : Collections.emptyList();
    }

    public static int getBackupCount() {
        return Files.tportConfig.getConfig().getInt("backup.auto.count", 10);
    }

    public static void setBackupCount(int count) {
        Files.tportConfig.getConfig().set("backup.auto.count", (Object)count);
        Files.tportConfig.saveConfig();
    }

    public static boolean getBackupState() {
        return Files.tportConfig.getConfig().getBoolean("backup.auto.state", true);
    }

    public void setBackupState(boolean state) {
        Files.tportConfig.getConfig().set("backup.auto.state", (Object)state);
        Files.tportConfig.saveConfig();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            Message stateAsMessage = Auto.getBackupState() ? ColorTheme.formatTranslation(ColorTheme.ColorType.goodColor, ColorTheme.ColorType.varInfoColor, "tport.command.backup.auto.true", new Object[0]) : ColorTheme.formatTranslation(ColorTheme.ColorType.badColor, ColorTheme.ColorType.varInfoColor, "tport.command.backup.auto.false", new Object[0]);
            int count = Auto.getBackupCount();
            ColorTheme.sendInfoTranslation(player, "tport.command.backup.auto.getStateAndCount", stateAsMessage, count);
        } else if (args.length == 3) {
            if (!this.emptyCount.hasPermissionToRun(player, true)) {
                return;
            }
            try {
                int newCount = Integer.parseInt(args[2]);
                Auto.setBackupCount(newCount);
                ColorTheme.sendSuccessTranslation(player, "tport.command.backup.auto.setCountSucceeded", newCount);
            }
            catch (NumberFormatException nfe) {
                Boolean newState = Main.toBoolean(args[2]);
                if (newState == null) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport backup auto [true|false]");
                    return;
                }
                this.setBackupState(newState);
                ColorTheme.sendSuccessTranslation(player, "tport.command.backup.auto.setStateSucceeded", newState);
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport backup auto [state|count]");
        }
    }
}

