/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.FeatureTP;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.history.TeleportHistory;
import com.spaceman.tport.history.locationSource.WorldLocationSource;
import com.spaceman.tport.inventories.TPortInventories;
import com.spaceman.tport.tpEvents.TPEManager;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;

public class WorldCommand
extends SubCommand {
    private final EmptyCommand emptyWorld = new EmptyCommand();

    public WorldCommand() {
        this.emptyWorld.setCommandName("world", ArgumentType.OPTIONAL);
        this.emptyWorld.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.worldCommand.world.world.commandDescription", new Object[0]));
        this.emptyWorld.setPermissions("TPort.world.tp");
        this.addAction(this.emptyWorld);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.worldCommand.world.commandDescription", new Object[0]));
        this.setPermissions(this.emptyWorld.getPermissions());
    }

    @Override
    public String getName(String arg) {
        return "world";
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (this.emptyWorld.hasPermissionToRun(player, false)) {
            return Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public void run(String[] args, Player player) {
        if (Features.Feature.WorldTP.isDisabled()) {
            Features.Feature.WorldTP.sendDisabledMessage(player);
            return;
        }
        if (args.length == 1) {
            TPortInventories.openWorldTP(player);
        } else if (args.length == 2) {
            if (!this.emptyWorld.hasPermissionToRun(player, true)) {
                return;
            }
            World world = Bukkit.getWorld((String)args[1]);
            if (world == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.worldCommand.world.world.worldNotExist", args[1]);
                return;
            }
            Location location = FeatureTP.setSafeY(world, world.getSpawnLocation().getBlockX(), world.getSpawnLocation().getBlockZ());
            if (location == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.worldCommand.world.world.notSafe", world);
                return;
            }
            location.add(0.5, 0.1, 0.5);
            TeleportHistory.setLocationSource(player.getUniqueId(), new WorldLocationSource(world));
            TPEManager.requestTeleportPlayer(player, location, true, () -> {
                ColorTheme.sendSuccessTranslation(player, "tport.command.worldCommand.world.world.succeeded", world);
                TPortAdvancement.Advancement_AWholeNewWorld.grant(player);
            }, (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.command.worldCommand.world.world.tpRequested", world, delay, tickMessage, seconds, secondMessage));
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport world [world]");
        }
    }
}

