/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.commandHandler.CommandTemplate;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.tag.Create;
import com.spaceman.tport.commands.tport.tag.Delete;
import com.spaceman.tport.commands.tport.tag.List;
import com.spaceman.tport.commands.tport.tag.Reset;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.entity.Player;

public class Tag
extends SubCommand {
    private static java.util.List<String> tags = new ArrayList<String>();
    public static final String tagPermPrefix = "TPort.tags.type.";

    public Tag() {
        this.addAction(new Create());
        this.addAction(new Delete());
        this.addAction(new List());
        this.addAction(new Reset());
    }

    public static void loadTags() {
        tags = Files.tportConfig.getConfig().getStringList("tags.list");
    }

    public static void saveTags() {
        Files.tportConfig.getConfig().set("tags.list", tags);
        Files.tportConfig.saveConfig();
    }

    public static boolean createTag(String tag) {
        if (tags.stream().noneMatch(s -> s.equalsIgnoreCase(tag))) {
            tags.add(tag);
            return true;
        }
        return false;
    }

    public static boolean deleteTag(String tag) {
        for (String t : tags) {
            if (!t.equalsIgnoreCase(tag)) continue;
            tags.remove(t);
            Tag.saveTags();
            for (String uuid : Files.tportData.getKeys("tport")) {
                for (TPort tport : TPortManager.getTPortList(UUID.fromString(uuid))) {
                    if (!tport.removeTag(t)) continue;
                    tport.save();
                }
            }
            return true;
        }
        return false;
    }

    public static void resetTags() {
        tags = new ArrayList<String>();
        Tag.createTag("Home");
        Tag.createTag("Spawner");
        Tag.createTag("Farm");
        Tag.createTag("Base");
        Tag.createTag("Mine");
        Tag.createTag("Temp");
        Tag.saveTags();
        for (String uuid : Files.tportData.getKeys("tport")) {
            for (TPort tport : TPortManager.getTPortList(UUID.fromString(uuid))) {
                for (String tag : tport.getTags()) {
                    tport.removeTag(tag);
                    tport.save();
                }
            }
        }
    }

    public static ArrayList<String> getTags() {
        return new ArrayList<String>(tags);
    }

    public static String getTag(String tag) {
        return tags.stream().filter(s -> s.equalsIgnoreCase(tag)).findFirst().orElse(null);
    }

    public static boolean exist(String tag) {
        return tags.stream().anyMatch(s -> s.equalsIgnoreCase(tag));
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length > 1 && CommandTemplate.runCommands(this.getActions(), args[1], args, player)) {
            return;
        }
        ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport tag " + CommandTemplate.convertToArgs(this.getActions(), false));
    }
}

