/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.Main;
import com.spaceman.tport.Pair;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.inventories.ItemFactory;
import com.spaceman.tport.inventories.TPortInventories;
import com.spaceman.tport.permissions.PermissionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Sort
extends SubCommand {
    private static final String permissionPrefix = "TPort.sort.";
    private static final HashMap<String, Pair<Sorter, Message>> sorters = new HashMap();

    public Sort() {
        EmptyCommand emptySorter = new EmptyCommand();
        emptySorter.setCommandName("sorter", ArgumentType.OPTIONAL);
        emptySorter.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.sort.sorter.commandDescription", new Object[0]));
        emptySorter.setPermissions("TPort.sort.<sorter>");
        this.addAction(emptySorter);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.sort.commandDescription", new Object[0]));
        this.registerSorters();
    }

    private void registerSorters() {
        Sort.addSorter("alphabet", (player, attributes, headData) -> {
            ArrayList<String> playerList = new ArrayList<String>(Files.tportData.getKeys("tport"));
            return playerList.stream().map(playerUUID -> Main.getOrDefault(ItemFactory.getHead(UUID.fromString(playerUUID), player, (List<ItemFactory.HeadAttributes>)attributes, headData), new ItemStack(Material.AIR))).sorted((item1, item2) -> item1.getItemMeta().getDisplayName().compareToIgnoreCase(item2.getItemMeta().getDisplayName())).collect(Collectors.toList());
        }, ColorTheme.formatInfoTranslation("tport.main.sorter.alphabet.description", new Object[0]));
        Sort.addSorter("oldest", (player, attributes, headData) -> {
            ArrayList<String> playerList = new ArrayList<String>(Files.tportData.getKeys("tport"));
            return playerList.stream().map(playerUUID -> Main.getOrDefault(ItemFactory.getHead(UUID.fromString(playerUUID), player, (List<ItemFactory.HeadAttributes>)attributes, headData), new ItemStack(Material.AIR))).collect(Collectors.toList());
        }, ColorTheme.formatInfoTranslation("tport.main.sorter.oldest.description", new Object[0]));
        Sort.addSorter("newest", (player, attributes, headData) -> {
            ArrayList<String> playerList = new ArrayList<String>(Files.tportData.getKeys("tport"));
            Collections.reverse(playerList);
            return playerList.stream().map(playerUUID -> Main.getOrDefault(ItemFactory.getHead(UUID.fromString(playerUUID), player, (List<ItemFactory.HeadAttributes>)attributes, headData), new ItemStack(Material.AIR))).collect(Collectors.toList());
        }, ColorTheme.formatInfoTranslation("tport.main.sorter.newest.description", new Object[0]));
    }

    public static Set<String> getSorters() {
        return sorters.keySet();
    }

    public static Message getDescription(String name) {
        return sorters.getOrDefault(name, new Pair<Object, Object>(null, null)).getRight();
    }

    public static Sorter getSorter(String name) {
        Sorter sorter = Sort.getSorterExact(name);
        if (sorter == null && (sorter = Sort.getSorterExact("oldest")) == null) {
            sorter = Sort.getSorterExact(Sort.getSorters().iterator().next());
        }
        return sorter;
    }

    public static String getSorterForPlayer(Player player) {
        return Files.tportData.getConfig().getString("tport." + String.valueOf(player.getUniqueId()) + ".sorter", "oldest");
    }

    public static Sorter getSorter(Player player) {
        return Sort.getSorter(Sort.getSorterForPlayer(player));
    }

    public static String getNextSorterName(Player player) {
        String sorter;
        int i;
        String currentSorter = Sort.getSorterForPlayer(player);
        ArrayList<String> list = new ArrayList<String>(Sort.getSorters());
        boolean next = false;
        int indexOfCurrent = 0;
        for (i = 0; i < list.size(); ++i) {
            sorter = list.get(i);
            if (next) {
                if (!PermissionHandler.hasPermission(player, false, permissionPrefix + sorter)) continue;
                return sorter;
            }
            if (!sorter.equalsIgnoreCase(currentSorter)) continue;
            next = true;
            indexOfCurrent = i;
        }
        for (i = 0; i < indexOfCurrent; ++i) {
            sorter = list.get(i);
            if (!PermissionHandler.hasPermission(player, false, permissionPrefix + sorter)) continue;
            return sorter;
        }
        return null;
    }

    @Nullable
    public static String getPreviousSorterName(Player player) {
        String sorter;
        int i;
        String currentSorter = Sort.getSorterForPlayer(player);
        ArrayList<String> list = new ArrayList<String>(Sort.getSorters());
        boolean next = false;
        int indexOfCurrent = 0;
        for (i = list.size() - 1; i >= 0; --i) {
            sorter = list.get(i);
            if (next) {
                if (!PermissionHandler.hasPermission(player, false, permissionPrefix + sorter)) continue;
                return sorter;
            }
            if (!sorter.equalsIgnoreCase(currentSorter)) continue;
            next = true;
            indexOfCurrent = i;
        }
        for (i = list.size() - 1; i > indexOfCurrent; --i) {
            sorter = list.get(i);
            if (!PermissionHandler.hasPermission(player, false, permissionPrefix + sorter)) continue;
            return sorter;
        }
        return null;
    }

    public static Sorter getSorterExact(String name) {
        return sorters.getOrDefault(name, new Pair<Object, Object>(null, null)).getLeft();
    }

    public static boolean addSorter(String name, Sorter sorter, Message description) {
        if (!sorters.containsKey(name) && !name.contains(" ")) {
            sorters.put(name, new Pair<Sorter, Message>(sorter, description));
            return true;
        }
        return false;
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return Sort.getSorters();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 1) {
            String sorterName = Files.tportData.getConfig().getString("tport." + String.valueOf(player.getUniqueId()) + ".sorter", "oldest");
            if (Sort.getSorter(sorterName) != null) {
                Files.tportData.getConfig().set("tport." + String.valueOf(player.getUniqueId()) + ".sorter", (Object)"oldest");
                Files.tportData.saveConfig();
                sorterName = "oldest";
            }
            Message availableSorters = new Message();
            ArrayList<String> sorters = new ArrayList<String>(Sort.getSorters());
            int sortersSize = sorters.size();
            boolean color = true;
            for (int i = 0; i < sortersSize; ++i) {
                String sorter = sorters.get(i);
                availableSorters.addText(TextComponent.textComponent(sorter, color ? ColorTheme.ColorType.varInfoColor : ColorTheme.ColorType.varInfo2Color, new HoverEvent(Sort.getDescription(sorter))));
                if (i + 2 == sortersSize) {
                    availableSorters.addMessage(ColorTheme.formatInfoTranslation("tport.command.sort.lastDelimiter", new Object[0]));
                } else {
                    availableSorters.addMessage(ColorTheme.formatInfoTranslation("tport.command.sort.delimiter", new Object[0]));
                }
                color = !color;
            }
            availableSorters.removeLast();
            ColorTheme.sendInfoTranslation(player, "tport.command.sort.succeeded", TextComponent.textComponent(sorterName, ColorTheme.ColorType.varInfoColor, new HoverEvent(Sort.getDescription(sorterName))), availableSorters);
        } else if (args.length == 2) {
            if (Sort.setSorter(player, args[1])) {
                TPortInventories.openMainTPortGUI(player);
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport sort [sorter]");
        }
    }

    public static boolean setSorter(Player player, String sorterName) {
        Sorter sorter = Sort.getSorterExact(sorterName);
        if (sorter == null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.sort.sorter.notExist", sorterName);
            return false;
        }
        if (!PermissionHandler.hasPermission(player, true, permissionPrefix + sorterName)) {
            return false;
        }
        Files.tportData.getConfig().set("tport." + String.valueOf(player.getUniqueId()) + ".sorter", (Object)sorterName);
        Files.tportData.saveConfig();
        ColorTheme.sendSuccessTranslation(player, "tport.command.sort.sorter.succeeded", sorterName);
        return true;
    }

    @FunctionalInterface
    public static interface Sorter {
        public List<ItemStack> sort(Player var1, List<ItemFactory.HeadAttributes> var2, @Nullable Object var3);
    }
}

