/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Add;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Restore
extends SubCommand {
    private static final HashMap<UUID, TPort> tportBin = new HashMap();

    public Restore() {
        this.setPermissions(Add.emptyAddTPort_permissions);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.restore.commandDescription", new Object[0]));
    }

    @Override
    public Message permissionsHover() {
        return ColorTheme.formatInfoTranslation("tport.command.add.tportName.permissionHover", Add.emptyAddTPort_permissions);
    }

    public static TPort getRestoreTPort(UUID owner) {
        return tportBin.getOrDefault(owner, null);
    }

    public static void setRestoreTPort(UUID owner, TPort toRestore) {
        tportBin.put(owner, toRestore);
    }

    @Override
    public void run(String[] args, Player player) {
        TPort addedTPort;
        if (args.length != 1) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport restore");
            return;
        }
        TPort restoreTPort = Restore.getRestoreTPort(player.getUniqueId());
        if (restoreTPort == null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.restore.noRestore", new Object[0]);
            return;
        }
        if (Features.Feature.TPortTakesItem.isEnabled()) {
            ItemStack item = new ItemStack(player.getInventory().getItemInMainHand());
            if (item.getType().equals((Object)Material.AIR)) {
                ColorTheme.sendErrorTranslation(player, "tport.command.restore.noItem", new Object[0]);
                return;
            }
            restoreTPort.setItem(item);
        }
        if ((addedTPort = TPortManager.addTPort(player, restoreTPort, true)) != null) {
            tportBin.remove(player.getUniqueId());
            TPortAdvancement.Advancement_whoops.grant(player);
            if (Features.Feature.TPortTakesItem.isEnabled()) {
                player.getInventory().setItem(player.getInventory().getHeldItemSlot(), new ItemStack(Material.AIR));
                addedTPort.setShouldReturnItem(true);
            } else {
                addedTPort.setShouldReturnItem(false);
            }
            addedTPort.save();
        }
    }
}

