/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.Main;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.advancements.TPortAdvancementManager;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.CommandTemplate;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.resourcePack.ResolutionCommand;
import com.spaceman.tport.commands.tport.resourcePack.State;
import com.spaceman.tport.events.JoinEvent;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.fileHander.Files;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ResourcePack
extends SubCommand {
    public ResourcePack() {
        EmptyCommand empty = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return "";
            }
        };
        empty.setCommandName("", ArgumentType.FIXED);
        empty.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.resourcePack.commandDescription", new Object[0]));
        this.addAction(empty);
        this.addAction(new State());
        this.addAction(new ResolutionCommand());
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 1) {
            boolean state = Files.tportConfig.getConfig().getBoolean("resourcePack." + String.valueOf(player.getUniqueId()) + ".state", false);
            Message stateMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.resourcePack." + (state ? "enabled" : "disabled"), new Object[0]);
            String releasePath = "https://github.com/JasperBouwman/TPort/releases/tag/TPort%20" + Main.getInstance().getDescription().getVersion();
            Message hereMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.resourcePack.here", new Object[0]);
            hereMessage.getText().forEach(t -> t.setInsertion(releasePath).addTextEvent(HoverEvent.hoverEvent(TextComponent.textComponent(releasePath, ColorTheme.ColorType.infoColor))).addTextEvent(ClickEvent.openUrl(releasePath)));
            ColorTheme.sendInfoTranslation(player, "tport.command.resourcePack.succeeded", stateMessage, ResourcePack.getResourcePackResolution(player.getUniqueId()), hereMessage);
        } else if (args.length > 1) {
            if (!CommandTemplate.runCommands(this.getActions(), args[1], args, player)) {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport resourcePack " + CommandTemplate.convertToArgs(this.getActions(), false));
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport resourcePack " + CommandTemplate.convertToArgs(this.getActions(), false));
        }
    }

    public static boolean getResourcePackState(UUID uuid) {
        return Files.tportConfig.getConfig().getBoolean("resourcePack." + String.valueOf(uuid) + ".state", false);
    }

    public static void setResourcePackState(UUID uuid, boolean state) {
        Files.tportConfig.getConfig().set("resourcePack." + String.valueOf(uuid) + ".state", (Object)state);
        Files.tportConfig.saveConfig();
    }

    public static ResolutionCommand.Resolution getResourcePackResolution(UUID uuid) {
        return ResolutionCommand.Resolution.getResolution(Files.tportConfig.getConfig().getString("resourcePack." + String.valueOf(uuid) + ".resolution"), "x16");
    }

    public static void setResourcePackResolution(UUID uuid, ResolutionCommand.Resolution resolution) {
        Files.tportConfig.getConfig().set("resourcePack." + String.valueOf(uuid) + ".resolution", (Object)resolution.getName());
        Files.tportConfig.saveConfig();
    }

    public static void updateResourcePack(Player player, boolean delayAdvancement) {
        ResolutionCommand.Resolution res;
        String resourcePath;
        if (ResourcePack.getResourcePackState(player.getUniqueId()) && (resourcePath = (res = ResourcePack.getResourcePackResolution(player.getUniqueId())).getUrl()) != null) {
            player.setResourcePack(resourcePath, null, "For a best experience with TPort you should enable the TPort Resource Pack", false);
            JoinEvent.playerResourceList.add(player.getUniqueId());
        }
        if (TPortAdvancement.isActive()) {
            int time = delayAdvancement ? 50 : 0;
            Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> {
                TPortAdvancement.Advancement_OhNoMyButtons.grant(player);
                TPortAdvancementManager.reInitAdvancements(player);
            }, (long)time);
        }
    }
}

