/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.playerUUID.PlayerUUID;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class RemovePlayer
extends SubCommand {
    private static final EmptyCommand emptyPlayer = new EmptyCommand();

    public RemovePlayer() {
        emptyPlayer.setCommandName("player", ArgumentType.REQUIRED);
        emptyPlayer.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.removePlayer.player.commandDescription", new Object[0]));
        emptyPlayer.setPermissions("TPort.admin.removePlayer");
        this.addAction(emptyPlayer);
    }

    public List<String> tabList(Player player, String[] args) {
        List<String> list = new ArrayList<String>();
        if (emptyPlayer.hasPermissionToRun(player, false)) {
            list = Files.tportData.getKeys("tport").stream().map(PlayerUUID::getPlayerName).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length != 2) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport removePlayer <player>");
            return;
        }
        RemovePlayer.removePlayer(player, args[1]);
    }

    public static void removePlayer(Player player, String toRemoveName) {
        UUID newPlayerUUID;
        block6: {
            if (!emptyPlayer.hasPermissionToRun(player, true)) {
                return;
            }
            try {
                newPlayerUUID = UUID.fromString(toRemoveName);
            }
            catch (IllegalArgumentException lae) {
                newPlayerUUID = PlayerUUID.getPlayerUUID_OLD2(toRemoveName);
                if (newPlayerUUID != null) break block6;
                ColorTheme.sendErrorTranslation(player, "tport.command.playerNotFound", toRemoveName);
                return;
            }
        }
        Player newPlayer = Bukkit.getPlayer((UUID)newPlayerUUID);
        if (newPlayer != null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.removePlayer.player.isOnline", newPlayer);
            return;
        }
        if (Files.tportData.getConfig().contains("tport." + String.valueOf(newPlayerUUID))) {
            Files.tportData.getConfig().set("tport." + String.valueOf(newPlayerUUID), null);
            Files.tportData.saveConfig();
            ColorTheme.sendSuccessTranslation(player, "tport.command.removePlayer.player.succeeded", toRemoveName);
        } else {
            ColorTheme.sendInfoTranslation(player, "tport.command.removePlayer.player.alreadyRemoved", toRemoveName);
        }
    }
}

