/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.Main;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Adapter;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.commands.tport.Tag;
import com.spaceman.tport.commands.tport.backup.Auto;
import com.spaceman.tport.cooldown.CooldownManager;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.language.Language;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.tpEvents.TPEManager;
import com.spaceman.tport.webMaps.BlueMapHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Level;
import org.bukkit.entity.Player;

public class Reload
extends SubCommand {
    public Reload() {
        this.setPermissions("TPort.admin.reload");
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.reload.commandDescription", new Object[0]));
    }

    public static void reloadTPort() {
        for (String file : Arrays.asList("TPortConfig.yml", "Permissions.txt")) {
            if (new File(Main.getInstance().getDataFolder(), file).exists()) continue;
            InputStream inputStream = Main.getInstance().getResource(file);
            try {
                byte[] buffer = new byte[inputStream.available()];
                inputStream.read(buffer);
                try (FileOutputStream fos = new FileOutputStream(new File(Main.getInstance().getDataFolder(), file));){
                    fos.write(buffer);
                }
                Main.getInstance().getLogger().log(Level.INFO, file + " did not exist, resetting it...");
            }
            catch (IOException iOException) {}
        }
        Files.reloadFiles();
        Adapter.loadAdapter(null);
        if (!Files.tportConfig.getConfig().contains("biomeTP.searches")) {
            Files.tportConfig.getConfig().set("biomeTP.searches", (Object)100);
            Files.tportConfig.saveConfig();
        }
        if (!Files.tportConfig.getConfig().contains("tags.list")) {
            Tag.resetTags();
        }
        Language.loadLanguages();
        CooldownManager.setDefaultValues();
        TPEManager.loadTPE(Files.tportConfig);
        ColorTheme.loadThemes(Files.tportConfig);
        Tag.loadTags();
        try {
            BlueMapHandler.disable();
            if (Features.Feature.BlueMap.isEnabled()) {
                try {
                    BlueMapHandler.enable();
                }
                catch (Throwable ignored) {
                    Main.getInstance().getLogger().log(Level.SEVERE, "Tried to enable BlueMap support, BlueMap API was not found");
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void run(String[] args, Player player) {
        if (this.hasPermissionToRun(player, true)) {
            Reload.reloadTPort();
            Auto.save();
            ColorTheme.sendInfoTranslation(player, "tport.command.reload.succeeded", new Object[0]);
        }
    }
}

