/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.commands.tport.pltp.Preview;
import com.spaceman.tport.events.PreviewEvents;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Preview
extends SubCommand {
    private final EmptyCommand emptyPreviewPlayerTPort = new EmptyCommand();
    private final EmptyCommand emptyPreviewPlayer;

    public Preview() {
        this.emptyPreviewPlayerTPort.setCommandName("TPort name", ArgumentType.OPTIONAL);
        this.emptyPreviewPlayerTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.preview.player.tportName.commandDescription", new Object[0]));
        this.emptyPreviewPlayerTPort.setPermissions("TPort.preview.tport", "TPort.basic");
        this.emptyPreviewPlayer = new EmptyCommand();
        this.emptyPreviewPlayer.setCommandName("player", ArgumentType.REQUIRED);
        this.emptyPreviewPlayerTPort.setPermissions("TPort.preview.player", "TPort.basic");
        this.emptyPreviewPlayer.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.preview.player.commandDescription", new Object[0]));
        this.emptyPreviewPlayer.setTabRunnable((args, player) -> {
            UUID argOneUUID = PlayerUUID.getPlayerUUID(args[1]);
            if (argOneUUID == null) {
                return Collections.emptyList();
            }
            return TPortManager.getTPortList(argOneUUID).stream().map(TPort::getName).collect(Collectors.toList());
        });
        this.emptyPreviewPlayer.addAction(this.emptyPreviewPlayerTPort);
        this.addAction(this.emptyPreviewPlayer);
        PreviewEvents.register();
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return PlayerUUID.getPlayerNames();
    }

    @Override
    public void run(String[] args, Player player) {
        if (Features.Feature.Preview.isDisabled()) {
            Features.Feature.Preview.sendDisabledMessage(player);
            return;
        }
        if (args.length == 2) {
            if (!this.emptyPreviewPlayer.hasPermissionToRun(player, true)) {
                return;
            }
            String newPlayerName = args[1];
            UUID newPlayerUUID = PlayerUUID.getPlayerUUID(newPlayerName, player);
            if (newPlayerUUID == null) {
                return;
            }
            if (newPlayerUUID.equals(player.getUniqueId())) {
                ColorTheme.sendErrorTranslation(player, "tport.command.preview.player.cantPreviewSelf", new Object[0]);
                return;
            }
            Player preview = Bukkit.getPlayer((UUID)newPlayerUUID);
            if (preview == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.playerNotOnline", PlayerEncapsulation.asPlayer(newPlayerUUID));
                return;
            }
            Preview.PreviewState previewState = com.spaceman.tport.commands.tport.pltp.Preview.getPreviewState(newPlayerUUID);
            if (previewState == Preview.PreviewState.OFF) {
                ColorTheme.sendInfoTranslation(player, "tport.command.preview.player.stateOFF", PlayerEncapsulation.asPlayer(preview), previewState);
                return;
            }
            PreviewEvents.preview(player, preview);
            if (previewState == Preview.PreviewState.NOTIFIED) {
                ColorTheme.sendInfoTranslation(preview, "tport.command.preview.player.notifyOwner", PlayerEncapsulation.asPlayer(player));
            }
        } else if (args.length == 3) {
            if (!this.emptyPreviewPlayerTPort.hasPermissionToRun(player, true)) {
                return;
            }
            String newPlayerName = args[1];
            UUID newPlayerUUID = PlayerUUID.getPlayerUUID(newPlayerName, player);
            if (newPlayerUUID == null) {
                return;
            }
            TPort tport = TPortManager.getTPort(newPlayerUUID, args[2]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[2]);
                return;
            }
            if (tport.getPreviewState() == TPort.PreviewState.OFF) {
                ColorTheme.sendInfoTranslation(player, "tport.command.preview.player.tportName.stateOFF", TPortEncapsulation.asTPort(tport), tport.getPreviewState());
                return;
            }
            PreviewEvents.preview(player, tport);
            if (tport.getPreviewState() == TPort.PreviewState.NOTIFIED) {
                ColorTheme.sendInfoTranslation(Bukkit.getPlayer((UUID)tport.getOwner()), "tport.command.preview.player.tportName.notifyOwner", PlayerEncapsulation.asPlayer(player), TPortEncapsulation.asTPort(tport));
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport preview <player> [TPort name]");
        }
    }
}

