/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.Main;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.inventories.TPortInventories;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;

public class Open
extends SubCommand {
    private static final Open instance = new Open();
    public final EmptyCommand emptyOpenPlayerTPort = new EmptyCommand();

    public static Open getInstance() {
        return instance;
    }

    public Open() {
        EmptyCommand emptyOpenPlayerTPortSafetyCheck = new EmptyCommand(){

            @Override
            public Message permissionsHover() {
                return ColorTheme.formatInfoTranslation("tport.command.open.player.tport.safetyCheck.permissionHover", "TPort.open", SafetyCheck.SafetyCheckSource.TPORT_OPEN.getPermission(), "TPort.basic");
            }
        };
        emptyOpenPlayerTPortSafetyCheck.setCommandName("safetyCheck", ArgumentType.OPTIONAL);
        emptyOpenPlayerTPortSafetyCheck.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.open.player.tport.safetyCheck.commandDescription", new Object[0]));
        emptyOpenPlayerTPortSafetyCheck.setPermissions("TPort.open", SafetyCheck.SafetyCheckSource.TPORT_OPEN.getPermission(), "TPort.basic");
        this.emptyOpenPlayerTPort.setCommandName("TPort name", ArgumentType.OPTIONAL);
        this.emptyOpenPlayerTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.open.player.tport.commandDescription", new Object[0]));
        this.emptyOpenPlayerTPort.setTabRunnable((args, player) -> {
            if (!emptyOpenPlayerTPortSafetyCheck.hasPermissionToRun(player, false)) {
                return Collections.emptyList();
            }
            return Arrays.asList("true", "false");
        });
        this.emptyOpenPlayerTPort.addAction(emptyOpenPlayerTPortSafetyCheck);
        this.emptyOpenPlayerTPort.setPermissions("TPort.open", "TPort.basic");
        EmptyCommand emptyOpenPlayer = new EmptyCommand();
        emptyOpenPlayer.setCommandName("player", ArgumentType.REQUIRED);
        emptyOpenPlayer.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.open.player.commandDescription", new Object[0]));
        emptyOpenPlayer.setTabRunnable((args, player) -> {
            UUID playerUUID = PlayerUUID.getPlayerUUID(args[1]);
            if (playerUUID == null) {
                return Collections.emptyList();
            }
            ArrayList<String> list = new ArrayList<String>();
            for (TPort tport : TPortManager.getTPortList(playerUUID)) {
                Boolean access = tport.hasAccess(player);
                if (access != null && !access.booleanValue()) continue;
                list.add(tport.getName());
            }
            return list;
        });
        emptyOpenPlayer.addAction(this.emptyOpenPlayerTPort);
        this.addAction(emptyOpenPlayer);
    }

    public List<String> tabList(Player player, String[] args) {
        if (!this.emptyOpenPlayerTPort.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return PlayerUUID.getPlayerNames();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            String newPlayerName = args[1];
            UUID newPlayerUUID = PlayerUUID.getPlayerUUID(newPlayerName, player);
            if (newPlayerUUID != null) {
                TPortInventories.openTPortGUI(newPlayerUUID, player);
            }
        } else if (args.length == 3 || args.length == 4) {
            Boolean safetyCheck;
            String newPlayerName = args[1];
            if (!this.emptyOpenPlayerTPort.hasPermissionToRun(player, true)) {
                return;
            }
            UUID newPlayerUUID = PlayerUUID.getPlayerUUID(newPlayerName, player);
            if (newPlayerUUID == null) {
                return;
            }
            TPort tport = TPortManager.getTPort(newPlayerUUID, args[2]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[2]);
                return;
            }
            if (tport.getOwner().equals(player.getUniqueId())) {
                if (args.length == 4) {
                    if (!SafetyCheck.SafetyCheckSource.TPORT_OWN.hasPermission(player, true)) {
                        return;
                    }
                    safetyCheck = Main.toBoolean(args[3]);
                    if (safetyCheck == null) {
                        ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport open <player> [TPort name] [true|false]");
                        return;
                    }
                } else {
                    safetyCheck = SafetyCheck.SafetyCheckSource.TPORT_OWN.getState(player);
                }
            } else if (args.length == 4) {
                if (!SafetyCheck.SafetyCheckSource.TPORT_OPEN.hasPermission(player, true)) {
                    return;
                }
                safetyCheck = Main.toBoolean(args[3]);
                if (safetyCheck == null) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport open <player> [TPort name] [true|false]");
                    return;
                }
            } else {
                safetyCheck = SafetyCheck.SafetyCheckSource.TPORT_OPEN.getState(player);
            }
            TPortAdvancement advancement = null;
            if (tport.getOwner().equals(player.getUniqueId())) {
                advancement = TPortAdvancement.Advancement_familiar;
            }
            tport.teleport(player, safetyCheck, advancement);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport open <player> [TPort name] [safetyCheck]");
        }
    }
}

