/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.Main;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.TPortCommand;
import com.spaceman.tport.commands.tport.BlueMapCommand;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.MessageUtils;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.TextType;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.history.HistoryEvents;
import com.spaceman.tport.inventories.SettingsInventories;
import com.spaceman.tport.webMaps.DynmapHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class Features
extends SubCommand {
    private final EmptyCommand emptyFeatureSetState;
    private final boolean isDisabled = Feature.FeatureSettings.isDisabled();

    public Features() {
        this.emptyFeatureSetState = new EmptyCommand();
        this.emptyFeatureSetState.setCommandName("state", ArgumentType.OPTIONAL);
        this.emptyFeatureSetState.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.features.feature.state.state.commandDescription", new Object[0]));
        this.emptyFeatureSetState.setPermissions("TPort.features.setState", "TPort.admin.features");
        EmptyCommand emptyFeatureState = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return this.getCommandName();
            }
        };
        emptyFeatureState.setCommandName("state", ArgumentType.FIXED);
        emptyFeatureState.setTabRunnable((args, player) -> {
            if (!this.emptyFeatureSetState.hasPermissionToRun(player, false)) {
                return Collections.emptyList();
            }
            return Arrays.asList("true", "false");
        });
        emptyFeatureState.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.features.feature.state.commandDescription", new Object[0]));
        emptyFeatureState.addAction(this.emptyFeatureSetState);
        EmptyCommand emptyFeatureEmpty = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return "";
            }
        };
        emptyFeatureEmpty.setCommandName("", ArgumentType.FIXED);
        emptyFeatureEmpty.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.features.feature.commandDescription", new Object[0]));
        EmptyCommand emptyFeature = new EmptyCommand();
        emptyFeature.setCommandName("feature", ArgumentType.REQUIRED);
        emptyFeature.addAction(emptyFeatureEmpty);
        emptyFeature.addAction(emptyFeatureState);
        EmptyCommand empty = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return "";
            }
        };
        empty.setCommandName("", ArgumentType.FIXED);
        empty.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.features.commandDescription", new Object[0]));
        this.addAction(empty);
        this.addAction(emptyFeature);
    }

    public static void convert() {
        Boolean b = null;
        if (Files.tportConfig.getConfig().contains("public.enabled")) {
            b = Files.tportConfig.getConfig().getBoolean("public.enabled", true);
            Files.tportConfig.getConfig().set("public.enabled", null);
            Files.tportConfig.getConfig().set("features." + String.valueOf(Feature.PublicTP) + ".enabled", (Object)b);
        }
        if (Files.tportConfig.getConfig().contains("metrics.enabled")) {
            b = Files.tportConfig.getConfig().getBoolean("metrics.enabled", true);
            Files.tportConfig.getConfig().set("metrics.enabled", null);
            Files.tportConfig.getConfig().set("features." + String.valueOf(Feature.Metrics) + ".enabled", (Object)b);
        }
        if (Files.tportConfig.getConfig().contains("dynmap.enabled")) {
            b = Files.tportConfig.getConfig().getBoolean("dynmap.enabled", true);
            Files.tportConfig.getConfig().set("dynmap.enabled", null);
            Files.tportConfig.getConfig().set("features." + String.valueOf(Feature.Dynmap) + ".enabled", (Object)b);
        }
        if (Files.tportConfig.getConfig().contains("Permissions.enabled")) {
            b = Files.tportConfig.getConfig().getBoolean("Permissions.enabled", true);
            Files.tportConfig.getConfig().set("Permissions.enabled", null);
            Files.tportConfig.getConfig().set("features." + String.valueOf(Feature.Permissions) + ".enabled", (Object)b);
        }
        if (b != null) {
            Files.tportConfig.saveConfig();
        }
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return Feature.getStringValues();
    }

    @Override
    public void run(String[] args, Player player) {
        if (this.isDisabled) {
            Feature.FeatureSettings.sendDisabledMessage(player);
            return;
        }
        if (args.length == 1) {
            Message list = new Message();
            Message delimiter = ColorTheme.formatInfoTranslation("tport.command.features.delimiter", new Object[0]);
            Feature[] values = Feature.values();
            boolean color = true;
            for (int i = 0; i < values.length; ++i) {
                Feature feature = values[i];
                TextComponent stateMessage = feature.isEnabled() ? TextComponent.textComponent("tport.command.features.enable", ColorTheme.ColorType.goodColor).setType(TextType.TRANSLATE).addTextEvent(HoverEvent.hoverEvent("/tport features " + feature.name() + " state false", ColorTheme.ColorType.infoColor)).addTextEvent(ClickEvent.runCommand("/tport features " + feature.name() + " state false")).setInsertion("/tport features " + feature.name() + " state false") : TextComponent.textComponent("tport.command.features.disable", ColorTheme.ColorType.badColor).setType(TextType.TRANSLATE).addTextEvent(HoverEvent.hoverEvent("/tport features " + feature.name() + " state true", ColorTheme.ColorType.infoColor)).addTextEvent(ClickEvent.runCommand("/tport features " + feature.name() + " state true")).setInsertion("/tport features " + feature.name() + " state true");
                if (color) {
                    list.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.features.listElement", feature, stateMessage));
                } else {
                    list.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.features.listElement", feature, stateMessage));
                }
                boolean bl = color = !color;
                if (i + 2 == values.length) {
                    list.addMessage(ColorTheme.formatInfoTranslation("tport.command.features.lastDelimiter", new Object[0]));
                    continue;
                }
                list.addMessage(delimiter);
            }
            list.removeLast();
            ColorTheme.sendInfoTranslation(player, "tport.command.features.succeeded", list);
        } else if (args.length == 2) {
            Feature feature = Feature.get(args[1]);
            if (feature == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.features.feature.featureNotFound", args[1]);
                return;
            }
            Message stateMessage = feature.isEnabled() ? ColorTheme.formatTranslation(ColorTheme.ColorType.goodColor, ColorTheme.ColorType.varInfoColor, "tport.command.features.enable", new Object[0]) : ColorTheme.formatTranslation(ColorTheme.ColorType.badColor, ColorTheme.ColorType.varInfoColor, "tport.command.features.disable", new Object[0]);
            ColorTheme.sendInfoTranslation(player, "tport.command.features.feature.succeeded", feature, feature.getDescription(), stateMessage);
        } else if (args.length == 3 && args[2].equalsIgnoreCase("state")) {
            Feature feature = Feature.get(args[1]);
            if (feature == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.features.feature.featureNotFound", args[1]);
                return;
            }
            Message stateMessage = feature.isEnabled() ? ColorTheme.formatTranslation(ColorTheme.ColorType.goodColor, ColorTheme.ColorType.varInfoColor, "tport.command.features.enable", new Object[0]) : ColorTheme.formatTranslation(ColorTheme.ColorType.badColor, ColorTheme.ColorType.varInfoColor, "tport.command.features.disable", new Object[0]);
            ColorTheme.sendInfoTranslation(player, "tport.command.features.feature.getState", feature, stateMessage);
        } else if (args.length == 4 && args[2].equalsIgnoreCase("state")) {
            if (!this.emptyFeatureSetState.hasPermissionToRun(player, true)) {
                return;
            }
            Feature feature = Feature.get(args[1]);
            if (feature == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.features.feature.featureNotFound", args[1]);
                return;
            }
            Boolean newState = Main.toBoolean(args[3]);
            if (newState == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport features <feature> state [true|false]");
                return;
            }
            boolean oldState = feature.isEnabled();
            if (oldState == newState) {
                Message stateMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varErrorColor, ColorTheme.ColorType.varError2Color, "tport.command.features." + (newState != false ? "enable" : "disable"), new Object[0]);
                ColorTheme.sendErrorTranslation(player, "tport.command.features.feature.alreadyInState", feature, stateMessage);
                return;
            }
            feature.setState(newState).sendAndTranslateMessage(player);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport features <feature> state [state]");
        }
    }

    public static enum Feature implements MessageUtils.MessageDescription
    {
        BiomeTP(false, true, SettingsInventories.settings_features_biome_tp_model, SettingsInventories.settings_features_biome_tp_grayed_model),
        FeatureTP(false, true, SettingsInventories.settings_features_feature_tp_model, SettingsInventories.settings_features_feature_tp_grayed_model),
        BackTP(false, true, SettingsInventories.settings_features_back_tp_model, SettingsInventories.settings_features_back_tp_grayed_model),
        PublicTP(false, true, SettingsInventories.settings_features_public_tp_model, SettingsInventories.settings_features_public_tp_grayed_model),
        PLTP(false, true, SettingsInventories.settings_features_pltp_model, SettingsInventories.settings_features_pltp_grayed_model),
        Dynmap(false, true, DynmapHandler::onStateChange, SettingsInventories.settings_features_dynmap_model, SettingsInventories.settings_features_dynmap_grayed_model),
        BlueMap(false, true, BlueMapCommand::onStateChange, SettingsInventories.settings_features_bluemap_model, SettingsInventories.settings_features_bluemap_grayed_model),
        Metrics(false, true, SettingsInventories.settings_features_metrics_model, SettingsInventories.settings_features_metrics_grayed_model),
        CompanionTP(false, true, SettingsInventories.settings_features_companion_tp_model, SettingsInventories.settings_features_companion_tp_grayed_model),
        Permissions(false, false, SettingsInventories.settings_features_permissions_model, SettingsInventories.settings_features_permissions_grayed_model),
        ParticleAnimation(false, true, SettingsInventories.settings_features_particle_animation_model, SettingsInventories.settings_features_particle_animation_grayed_model),
        SafetyCheck(false, true, SettingsInventories.settings_features_safety_check_model, SettingsInventories.settings_features_safety_check_grayed_model),
        Redirects(false, true, SettingsInventories.settings_features_redirects_model, SettingsInventories.settings_features_redirects_grayed_model),
        History(false, false, HistoryEvents::onStateChange, SettingsInventories.settings_features_history_model, SettingsInventories.settings_features_history_grayed_model),
        Preview(false, true, SettingsInventories.settings_features_preview_model, SettingsInventories.settings_features_preview_grayed_model),
        WorldTP(false, true, SettingsInventories.settings_features_world_tp_model, SettingsInventories.settings_features_world_tp_grayed_model),
        Waypoints(false, true, SettingsInventories.settings_features_waypoints_model, SettingsInventories.settings_features_waypoints_grayed_model),
        TPortTakesItem(false, true, SettingsInventories.settings_features_tport_takes_item_model, SettingsInventories.settings_features_tport_takes_item_grayed_model),
        InterdimensionalTeleporting(false, true, SettingsInventories.settings_features_interdimensional_teleporting_model, SettingsInventories.settings_features_interdimensional_teleporting_grayed_model),
        DeathTP(false, true, SettingsInventories.settings_features_death_tp_model, SettingsInventories.settings_features_death_tp_grayed_model),
        LookTP(false, true, SettingsInventories.settings_features_look_tp_model, SettingsInventories.settings_features_look_tp_grayed_model),
        Advancements(false, true, TPortAdvancement::onStateChange, SettingsInventories.settings_features_advancement_model, SettingsInventories.settings_features_advancement_grayed_model),
        EnsureUniqueUUID(false, false, SettingsInventories.settings_features_ensure_unique_uuid_model, SettingsInventories.settings_features_ensure_unique_uuid_grayed_model),
        PrintErrorsInConsole(false, false, SettingsInventories.settings_features_print_errors_in_console_model, SettingsInventories.settings_features_print_errors_in_console_grayed_model),
        DisplayDisabledFeatures(false, true, SettingsInventories.settings_features_display_disabled_features_model, SettingsInventories.settings_features_display_disabled_features_grayed_model),
        FeatureSettings(false, true, SettingsInventories.settings_features_feature_settings_model, SettingsInventories.settings_features_feature_settings_grayed_model);

        private final boolean reloadCommands;
        private final boolean defaultValue;
        private final InventoryModel enabledModel;
        private final InventoryModel disabledModel;
        private final OnStateChange stateChange;

        private Feature(boolean reloadCommands, boolean defaultValue, InventoryModel enabledModel, InventoryModel disabledModel) {
            this.reloadCommands = reloadCommands;
            this.defaultValue = defaultValue;
            this.stateChange = newState -> {};
            this.enabledModel = enabledModel;
            this.disabledModel = disabledModel;
        }

        private Feature(boolean reloadCommands, boolean defaultValue, OnStateChange stateChange, InventoryModel enabledModel, InventoryModel disabledModel) {
            this.reloadCommands = reloadCommands;
            this.defaultValue = defaultValue;
            this.stateChange = stateChange;
            this.enabledModel = enabledModel;
            this.disabledModel = disabledModel;
        }

        public static List<String> getStringValues() {
            return Arrays.stream(Feature.values()).map(Enum::name).collect(Collectors.toList());
        }

        public static Feature get(String name) {
            for (Feature feature : Feature.values()) {
                if (!feature.name().equalsIgnoreCase(name)) continue;
                return feature;
            }
            return null;
        }

        public boolean isEnabled() {
            return Files.tportConfig.getConfig().getBoolean("features." + this.name() + ".enabled", this.defaultValue);
        }

        public boolean isDisabled() {
            return !this.isEnabled();
        }

        public Message setState(boolean newState) {
            Files.tportConfig.getConfig().set("features." + this.name() + ".enabled", (Object)newState);
            Files.tportConfig.saveConfig();
            if (this.reloadCommands) {
                TPortCommand.reRegisterActions();
            }
            if (this.stateChange != null) {
                this.stateChange.onChange(newState);
            }
            Message stateMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varSuccessColor, ColorTheme.ColorType.varSuccess2Color, "tport.command.features." + (newState ? "enable" : "disable"), new Object[0]);
            return ColorTheme.formatSuccessTranslation("tport.command.features.feature." + this.name() + ".setState", this, stateMessage, "/tport reload");
        }

        public Message getDisabledMessage() {
            Message stateMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varErrorColor, ColorTheme.ColorType.varError2Color, "tport.command.features.disable", new Object[0]);
            String command = "/tport features " + this.name() + " state true";
            return ColorTheme.formatErrorTranslation("tport.command.features.feature." + this.name() + ".disabledMessage", stateMessage, command);
        }

        public void sendDisabledMessage(Player player) {
            this.getDisabledMessage().sendAndTranslateMessage(player);
        }

        public static void printSmallNMSErrorInConsole(String nmsError, boolean usedBackup) {
            String message = "NMS Error in: " + nmsError;
            if (usedBackup) {
                message = message + ", used built-in backup. Some features may not keep their full functionality when their backup is used";
            }
            Main.getInstance().getLogger().log(Level.WARNING, message);
        }

        public InventoryModel getModel() {
            return this.isEnabled() ? this.enabledModel : this.disabledModel;
        }

        @Override
        public Message getDescription() {
            return ColorTheme.formatInfoTranslation("tport.command.features.feature." + this.name() + ".description", new Object[0]);
        }

        @Override
        public Message getName(String color, String varColor) {
            return new Message(new TextComponent(this.name(), varColor));
        }

        @Override
        public String getInsertion() {
            return this.name();
        }

        @FunctionalInterface
        private static interface OnStateChange {
            public void onChange(boolean var1);
        }
    }
}

