/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.CommandTemplate;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.commands.tport.dynmap.Colors;
import com.spaceman.tport.commands.tport.dynmap.IP;
import com.spaceman.tport.commands.tport.dynmap.Search;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.webMaps.DynmapHandler;
import org.bukkit.entity.Player;

public class DynmapCommand
extends SubCommand {
    public DynmapCommand() {
        if (Features.Feature.Dynmap.isEnabled()) {
            DynmapHandler.enable();
        } else {
            DynmapHandler.disable();
        }
        EmptyCommand empty = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return "";
            }
        };
        empty.setCommandName("", ArgumentType.FIXED);
        empty.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.dynmapCommand.commandDescription", new Object[0]));
        this.addAction(empty);
        this.addAction(new Search());
        this.addAction(new IP());
        this.addAction(new Colors());
    }

    @Override
    public String getName(String arg) {
        return "dynmap";
    }

    public static boolean checkDynmapState(Player player) {
        if (Features.Feature.Dynmap.isDisabled()) {
            Features.Feature.Dynmap.sendDisabledMessage(player);
            return false;
        }
        if (!DynmapHandler.isEnabled()) {
            ColorTheme.sendErrorTranslation(player, "tport.command.dynmapCommand.disableError", "/tport features dynmap state true");
            return false;
        }
        return true;
    }

    @Override
    public void run(String[] args, Player player) {
        if (!DynmapCommand.checkDynmapState(player)) {
            return;
        }
        TPortAdvancement.Advancement_ICanSeeItAll.grant(player);
        if (args.length == 1) {
            boolean enableBool = DynmapHandler.isEnabled();
            if (!enableBool) {
                Message enabledMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varErrorColor, ColorTheme.ColorType.varError2Color, "tport.command.dynmapCommand.disabled", new Object[0]);
                Message shouldEnableMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varErrorColor, ColorTheme.ColorType.varError2Color, "tport.command.dynmapCommand.enabled", new Object[0]);
                ColorTheme.sendErrorTranslation(player, "tport.command.dynmapCommand.couldNotEnable", enabledMessage, shouldEnableMessage);
                return;
            }
            Message enabledMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.goodColor, ColorTheme.ColorType.varInfo2Color, "tport.command.dynmapCommand.enabled", new Object[0]);
            Message shouldEnableMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.goodColor, ColorTheme.ColorType.varInfo2Color, "tport.command.dynmapCommand.enabled", new Object[0]);
            Message searchMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.dynmapCommand.searchAsText", new Object[0]);
            searchMessage.getText().forEach(textComponent -> textComponent.setInsertion("/tport dynmap search <player> [tport name]").addTextEvent(new HoverEvent(ColorTheme.formatInfoTranslation("tport.command.dynmapCommand.searchAsHover", "/tport dynmap search <player> [tport name]"))));
            ColorTheme.sendInfoTranslation(player, "tport.command.dynmapCommand.getInfo", shouldEnableMessage, enabledMessage, "/tport edit <TPort name> dynmap show <state>", "/tport edit <TPort name> dynmap icon <icon>", searchMessage, "/tport dynmap IP <ip>", "http://0.0.0.0:PORT/", "http://example.com/");
            return;
        }
        if (args.length > 1 && CommandTemplate.runCommands(this.getActions(), args[1], args, player)) {
            return;
        }
        ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport dynmap " + CommandTemplate.convertToArgs(this.getActions(), true));
    }
}

