/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.Main;
import com.spaceman.tport.Pair;
import com.spaceman.tport.commandHandler.CommandTemplate;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.MessageUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Player;

public class Docs
extends SubCommand {
    private final HashMap<String, Pair<ArrayList<String>, ArrayList<Message>>> docs = new HashMap();

    public Docs(CommandTemplate mainTemplate) {
        this.loadMD("quickStart.md", "/docs/quickStart.md", mainTemplate);
        this.loadMD("readme.md", "/docs/readme.md", mainTemplate);
        this.loadMD("changelog.md", "/docs/changelog.md", mainTemplate);
    }

    private void loadMD(String name, String mdFile, CommandTemplate mainTemplate) {
        try (InputStream md = Main.class.getResourceAsStream(mdFile);){
            if (md != null) {
                String mdText = IOUtils.toString((InputStream)md, (Charset)StandardCharsets.UTF_8);
                this.docs.put(name, MessageUtils.fromSplitMarkdown(mdText, mainTemplate));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return this.docs.keySet();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length != 1) {
            if (args.length == 2) {
                Pair chapters = this.docs.getOrDefault(args[1], null);
                if (chapters == null) {
                    player.sendMessage("no chapters found");
                } else {
                    ((ArrayList)chapters.getLeft()).forEach(arg_0 -> ((Player)player).sendMessage(arg_0));
                }
            } else {
                Pair chapters = this.docs.getOrDefault(args[1], null);
                if (chapters == null) {
                    player.sendMessage("no chapters found");
                } else {
                    String chapterInput = StringUtils.join((Object[])args, (String)" ", (int)2, (int)args.length);
                    ArrayList left = (ArrayList)chapters.getLeft();
                    for (int i = 0; i < left.size(); ++i) {
                        String chapterName = (String)left.get(i);
                        if (!chapterName.equalsIgnoreCase(chapterInput)) continue;
                    }
                }
            }
        }
    }
}

