/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.Main;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.CommandTemplate;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.commands.tport.blueMap.Colors;
import com.spaceman.tport.commands.tport.blueMap.IP;
import com.spaceman.tport.commands.tport.blueMap.Search;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.webMaps.BlueMapHandler;
import java.util.logging.Level;
import org.bukkit.entity.Player;

public class BlueMapCommand
extends SubCommand {
    public BlueMapCommand() {
        EmptyCommand empty = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return "";
            }
        };
        empty.setCommandName("", ArgumentType.FIXED);
        empty.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.blueMapCommand.commandDescription", new Object[0]));
        this.addAction(empty);
        this.addAction(new Search());
        this.addAction(new IP());
        this.addAction(new Colors());
    }

    @Override
    public String getName(String arg) {
        return "blueMap";
    }

    public static void onStateChange(boolean newState) {
        if (newState) {
            try {
                BlueMapHandler.enable();
            }
            catch (Throwable e) {
                Main.getInstance().getLogger().log(Level.SEVERE, "Tried to enable BlueMap support, BlueMap API was not found");
            }
        } else {
            try {
                BlueMapHandler.disable();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean checkBlueMapState(Player player) {
        if (Features.Feature.BlueMap.isDisabled()) {
            Features.Feature.BlueMap.sendDisabledMessage(player);
            return false;
        }
        boolean blueMapState = false;
        try {
            blueMapState = BlueMapHandler.isEnabled();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!blueMapState) {
            ColorTheme.sendErrorTranslation(player, "tport.command.blueMapCommand.disableError", "/tport features blueMap state true");
            return false;
        }
        return true;
    }

    @Override
    public void run(String[] args, Player player) {
        if (!BlueMapCommand.checkBlueMapState(player)) {
            return;
        }
        TPortAdvancement.Advancement_ICanSeeItAll.grant(player);
        if (args.length == 1) {
            ColorTheme.sendInfoTranslation(player, "tport.command.blueMapCommand", new Object[0]);
        } else if (args.length > 1 && CommandTemplate.runCommands(this.getActions(), args[1], args, player)) {
            return;
        }
        ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport blueMap " + CommandTemplate.convertToArgs(this.getActions(), true));
    }
}

