/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.Main;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.commands.tport.Open;
import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.commands.tport.pltp.Offset;
import com.spaceman.tport.cooldown.CooldownManager;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.BiomeEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.FeatureEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tpEvents.TPEManager;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class Back
extends SubCommand {
    public static HashMap<UUID, PrevTPort> prevTPorts = new HashMap();
    private final EmptyCommand emptySafetyCheck = new EmptyCommand(){

        @Override
        public Message permissionsHover() {
            return ColorTheme.formatInfoTranslation("tport.command.back.safetyCheck.permissionHover", "TPort.back", SafetyCheck.SafetyCheckSource.TPORT_BACK.getPermission(), "TPort.basic");
        }
    };

    public static String getPrevLocNameAsString(Player player) {
        if (prevTPorts.containsKey(player.getUniqueId())) {
            return "Previous location: " + prevTPorts.get(player.getUniqueId()).toString();
        }
        return "Previous location: Unknown";
    }

    public static Message getPrevLocName(Player player) {
        if (prevTPorts.containsKey(player.getUniqueId())) {
            return ColorTheme.formatInfoTranslation("tport.command.back.previousLocation", prevTPorts.get(player.getUniqueId()).toMessage());
        }
        return ColorTheme.formatInfoTranslation("tport.command.back.previousLocation", ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.back.previousLocationUnknown", new Object[0]));
    }

    public static boolean hasBack(Player player) {
        return prevTPorts.containsKey(player.getUniqueId());
    }

    public Back() {
        this.emptySafetyCheck.setCommandName("safetyCheck", ArgumentType.OPTIONAL);
        this.emptySafetyCheck.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.back.safetyCheck.commandDescription", new Object[0]));
        this.emptySafetyCheck.setPermissions("TPort.back", SafetyCheck.SafetyCheckSource.TPORT_BACK.getPermission(), "TPort.basic");
        this.addAction(this.emptySafetyCheck);
        this.setPermissions("TPort.back", "TPort.basic");
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.back.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptySafetyCheck.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Arrays.asList("true", "false", Back.getPrevLocNameAsString(player));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(String[] args, Player player) {
        if (Features.Feature.BackTP.isDisabled()) {
            Features.Feature.BackTP.sendDisabledMessage(player);
            return;
        }
        if (args.length > 2) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport back [safetyCheck]");
            return;
        }
        if (!this.hasPermissionToRun(player, true)) {
            return;
        }
        if (!CooldownManager.Back.hasCooled(player)) {
            return;
        }
        if (prevTPorts.containsKey(player.getUniqueId())) {
            Boolean safetyCheck;
            if (args.length == 2) {
                if (!SafetyCheck.SafetyCheckSource.TPORT_BACK.hasPermission(player, true)) return;
                safetyCheck = Main.toBoolean(args[1]);
                if (safetyCheck == null) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport back [true|false]");
                    return;
                }
            } else {
                safetyCheck = SafetyCheck.SafetyCheckSource.TPORT_BACK.getState(player);
            }
            if (!prevTPorts.get(player.getUniqueId()).tpBack(player, safetyCheck)) return;
            CooldownManager.Back.update(player);
            TPortAdvancement.Advancement_backToTheFuture.grant(player);
            return;
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.back.noLocationKnown", new Object[0]);
        }
    }

    public static class PrevTPort {
        private final HashMap<String, Object> data = new HashMap();
        private final PrevType prevType;

        public PrevTPort(PrevType prevType, String name1, Object data1, String name2, Object data2) {
            this.data.put(name1, data1);
            this.data.put(name2, data2);
            this.prevType = prevType;
        }

        public PrevTPort(PrevType prevType, String name1, Object data1, String name2, Object data2, String name3, Object data3) {
            this.data.put(name1, data1);
            this.data.put(name2, data2);
            this.data.put(name3, data3);
            this.prevType = prevType;
        }

        public PrevTPort(String prevType, String name1, Object data1, String name2, Object data2) {
            this.data.put(name1, data1);
            this.data.put(name2, data2);
            this.prevType = PrevType.valueOf(prevType);
        }

        public PrevTPort(String prevType, String name1, Object data1, String name2, Object data2, String name3, Object data3) {
            this.data.put(name1, data1);
            this.data.put(name2, data2);
            this.data.put(name3, data3);
            this.prevType = PrevType.valueOf(prevType);
        }

        public PrevTPort(String prevType, String name1, Object data1, String name2, Object data2, String name3, Object data3, String name4, Object data4) {
            this.data.put(name1, data1);
            this.data.put(name2, data2);
            this.data.put(name3, data3);
            this.data.put(name4, data4);
            this.prevType = PrevType.valueOf(prevType);
        }

        public boolean tpBack(Player player, boolean safetyCheck) {
            return this.prevType.tpBack(player, this, safetyCheck);
        }

        public String toString() {
            return this.prevType.toString(this);
        }

        public Message toMessage() {
            return this.prevType.toMessage(this);
        }

        public HashMap<String, Object> getData() {
            return this.data;
        }
    }

    public static enum PrevType {
        TPORT((player, prevTPort, safetyCheck) -> {
            Location prevLoc = (Location)prevTPort.getData().get("prevLoc");
            UUID tportUUID = (UUID)prevTPort.getData().get("tportUUID");
            String tportName = (String)prevTPort.getData().get("tportName");
            UUID tportOwner = (UUID)prevTPort.getData().get("tportOwner");
            TPort tport = TPortManager.getTPort(tportOwner, tportUUID);
            if (prevLoc == null) {
                if (!Open.getInstance().emptyOpenPlayerTPort.hasPermissionToRun(player, true)) {
                    return false;
                }
                if (tport == null) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.back.TPORT.to.tportNotFound", tportName);
                    return false;
                }
                prevTPorts.put(player.getUniqueId(), new PrevTPort("TPORT", "tportName", tport.getName(), "tportUUID", tport.getTportID(), "tportOwner", tportOwner, "prevLoc", player.getLocation()));
                if (tport.teleport(player, safetyCheck, false, null, "tport.command.back.TPORT.to.succeeded", "tport.command.back.TPORT.to.tpRequested")) {
                    return true;
                }
                prevTPorts.put(player.getUniqueId(), new PrevTPort("TPORT", "tportUUID", (Object)tportUUID, "tportOwner", (Object)tportOwner, "prevLoc", null));
                return false;
            }
            if (safetyCheck && !SafetyCheck.isSafe(prevLoc)) {
                ColorTheme.sendErrorTranslation(player, "tport.command.back.TPORT.from.notSafe", TPortEncapsulation.asTPort(tport, tportUUID, tportOwner, tportName));
                return false;
            }
            prevTPorts.put(player.getUniqueId(), new PrevTPort("TPORT", "tportName", tportName, "tportUUID", tportUUID, "tportOwner", tportOwner, "prevLoc", null));
            TPEManager.requestTeleportPlayer(player, prevLoc, () -> ColorTheme.sendSuccessTranslation(Bukkit.getPlayer((UUID)player.getUniqueId()), "tport.command.back.TPORT.from.succeeded", TPortEncapsulation.asTPort(tport, tportUUID, tportOwner, tportName)), (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.command.back.TPORT.from.tpRequested", TPortEncapsulation.asTPort(tport, tportUUID, tportOwner, tportName), delay, tickMessage, seconds, secondMessage));
            return true;
        }, prevTPort -> {
            Location prevLoc = (Location)prevTPort.getData().get("prevLoc");
            UUID tportUUID = (UUID)prevTPort.getData().get("tportUUID");
            UUID tportOwner = (UUID)prevTPort.getData().get("tportOwner");
            TPort tport = TPortManager.getTPort(tportOwner, tportUUID);
            if (prevLoc == null) {
                if (tport == null) {
                    return "Unknown";
                }
                return "To TPort " + tport.getName();
            }
            String tportName = (String)prevTPort.getData().get("tportName");
            return "From TPort " + tportName;
        }, prevTPort -> {
            Location prevLoc = (Location)prevTPort.getData().get("prevLoc");
            UUID tportOwner = (UUID)prevTPort.getData().get("tportOwner");
            UUID tportUUID = (UUID)prevTPort.getData().get("tportUUID");
            TPort tport = TPortManager.getTPort(tportOwner, tportUUID);
            String tportName = (String)prevTPort.getData().get("tportName");
            if (prevLoc == null) {
                if (tport == null) {
                    return ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.back.TPORT.to.previousLocationUnknown", tportName);
                }
                return ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.back.TPORT.to.previousLocation", TPortEncapsulation.asTPort(tport));
            }
            return ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.back.TPORT.from.previousLocation", TPortEncapsulation.asTPort(tport, tportUUID, tportOwner, tportName));
        }),
        BIOME((player, prevTPort, safetyCheck) -> {
            Location biomeLoc = (Location)prevTPort.getData().get("biomeLoc");
            Location prevLoc = prevTPort.getData().getOrDefault("prevLoc", null);
            String biomeName = (String)prevTPort.getData().get("biomeName");
            BiomeEncapsulation biome = new BiomeEncapsulation(biomeName);
            if (prevLoc == null) {
                if (safetyCheck && !SafetyCheck.isSafe(biomeLoc)) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.back.BIOME.to.notSafe", biome);
                    return false;
                }
                prevTPorts.put(player.getUniqueId(), new PrevTPort("BIOME", "biomeLoc", (Object)biomeLoc, "prevLoc", (Object)player.getLocation(), "biomeName", (Object)biomeName));
                TPEManager.requestTeleportPlayer(player, biomeLoc, () -> ColorTheme.sendSuccessTranslation(Bukkit.getPlayer((UUID)player.getUniqueId()), "tport.command.back.BIOME.to.succeeded", biome), (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.command.back.BIOME.to.tpRequested", biome, delay, tickMessage, seconds, secondMessage));
                return true;
            }
            if (safetyCheck && !SafetyCheck.isSafe(prevLoc)) {
                ColorTheme.sendErrorTranslation(player, "tport.command.back.BIOME.from.notSafe", biome);
                return false;
            }
            prevTPorts.put(player.getUniqueId(), new PrevTPort("BIOME", "biomeLoc", (Object)biomeLoc, "prevLoc", null, "biomeName", (Object)biomeName));
            TPEManager.requestTeleportPlayer(player, prevLoc, () -> ColorTheme.sendSuccessTranslation(Bukkit.getPlayer((UUID)player.getUniqueId()), "tport.command.back.BIOME.from.succeeded", biome), (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.command.back.BIOME.from.tpRequested", biome, delay, tickMessage, seconds, secondMessage));
            return true;
        }, prevTPort -> {
            String biomeName = (String)prevTPort.getData().get("biomeName");
            Location prevLoc = prevTPort.getData().getOrDefault("prevLoc", null);
            return (prevLoc == null ? "To" : "From") + " biome " + biomeName;
        }, prevTPort -> {
            String biomeName = (String)prevTPort.getData().get("biomeName");
            BiomeEncapsulation biome = new BiomeEncapsulation(biomeName);
            Location prevLoc = prevTPort.getData().getOrDefault("prevLoc", null);
            return ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.back.BIOME." + (prevLoc == null ? "to" : "from") + ".previousLocation", biome);
        }),
        FEATURE((player, prevTPort, safetyCheck) -> {
            Location featureLoc = (Location)prevTPort.getData().get("featureLoc");
            Location prevLoc = prevTPort.getData().getOrDefault("prevLoc", null);
            String featureName = (String)prevTPort.getData().get("featureName");
            FeatureEncapsulation feature = new FeatureEncapsulation(featureName);
            if (prevLoc == null) {
                if (safetyCheck && !SafetyCheck.isSafe(featureLoc)) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.back.FEATURE.to.notSafe", feature);
                    return false;
                }
                prevTPorts.put(player.getUniqueId(), new PrevTPort("FEATURE", "featureLoc", (Object)featureLoc, "prevLoc", (Object)player.getLocation(), "featureName", (Object)featureName));
                TPEManager.requestTeleportPlayer(player, featureLoc, () -> ColorTheme.sendSuccessTranslation(Bukkit.getPlayer((UUID)player.getUniqueId()), "tport.command.back.FEATURE.to.succeeded", feature), (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.command.back.FEATURE.to.tpRequested", feature, delay, tickMessage, seconds, secondMessage));
                return true;
            }
            if (safetyCheck && !SafetyCheck.isSafe(prevLoc)) {
                ColorTheme.sendErrorTranslation(player, "tport.command.back.FEATURE.from.notSafe", feature);
                return false;
            }
            prevTPorts.put(player.getUniqueId(), new PrevTPort("FEATURE", "featureLoc", (Object)featureLoc, "prevLoc", null, "featureName", (Object)featureName));
            TPEManager.requestTeleportPlayer(player, prevLoc, () -> ColorTheme.sendSuccessTranslation(Bukkit.getPlayer((UUID)player.getUniqueId()), "tport.command.back.FEATURE.from.succeeded", feature), (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.command.back.FEATURE.from.tpRequested", feature, delay, tickMessage, seconds, secondMessage));
            return true;
        }, prevTPort -> {
            String featureName = (String)prevTPort.getData().get("featureName");
            Location prevLoc = prevTPort.getData().getOrDefault("prevLoc", null);
            return (prevLoc == null ? "To " : "From ") + featureName;
        }, prevTPort -> {
            String featureName = (String)prevTPort.getData().get("featureName");
            FeatureEncapsulation feature = new FeatureEncapsulation(featureName);
            Location prevLoc = prevTPort.getData().getOrDefault("prevLoc", null);
            return ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.back.FEATURE." + (prevLoc == null ? "to" : "from") + ".previousLocation", feature);
        }),
        PLAYER((player, prevTPort, safetyCheck) -> {
            String toPlayerUUID = (String)prevTPort.getData().get("playerUUID");
            Player toPlayer = Bukkit.getPlayer((UUID)UUID.fromString(toPlayerUUID));
            Location prevLoc = prevTPort.getData().getOrDefault("prevLoc", null);
            if (prevLoc == null) {
                ArrayList whitelist;
                if (toPlayer == null) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.back.PLAYER.to.notOnlineAnymore", PlayerUUID.getPlayerName(toPlayerUUID));
                    return false;
                }
                if (!Files.tportData.getConfig().getBoolean("tport." + toPlayerUUID + ".tp.statement", true) && !(whitelist = (ArrayList)Files.tportData.getConfig().getStringList("tport." + toPlayerUUID + "tp.players")).contains(player.getUniqueId().toString())) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.back.PLAYER.to.whitelistError", new Object[0]);
                    return false;
                }
                Location location = Offset.getPLTPOffset(toPlayer).applyOffset(toPlayer.getLocation());
                if (safetyCheck && !SafetyCheck.isSafe(location)) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.back.PLAYER.to.notSafe", toPlayer);
                    return false;
                }
                prevTPorts.put(player.getUniqueId(), new PrevTPort("PLAYER", "playerUUID", (Object)toPlayerUUID, "prevLoc", (Object)player.getLocation()));
                TPEManager.requestTeleportPlayer(player, location, () -> {
                    ColorTheme.sendSuccessTranslation(Bukkit.getPlayer((UUID)player.getUniqueId()), "tport.command.back.PLAYER.to.succeeded", toPlayer);
                    ColorTheme.sendInfoTranslation(Bukkit.getPlayer((UUID)toPlayer.getUniqueId()), "tport.command.back.PLAYER.to.succeededOtherPlayer", player);
                }, (p, delay, tickMessage, seconds, secondMessage) -> {
                    ColorTheme.sendSuccessTranslation(p, "tport.command.back.PLAYER.to.toRequested", toPlayer, delay, tickMessage, seconds, secondMessage);
                    ColorTheme.sendInfoTranslation(toPlayer, "tport.command.back.PLAYER.to.requestedOtherPlayer", p);
                });
                return true;
            }
            if (safetyCheck && !SafetyCheck.isSafe(prevLoc)) {
                ColorTheme.sendErrorTranslation(player, "tport.command.back.PLAYER.from.notSafe", PlayerEncapsulation.asPlayer(toPlayer, UUID.fromString(toPlayerUUID)));
                return false;
            }
            prevTPorts.put(player.getUniqueId(), new PrevTPort("PLAYER", "playerUUID", (Object)toPlayerUUID, "prevLoc", null));
            TPEManager.requestTeleportPlayer(player, prevLoc, () -> ColorTheme.sendSuccessTranslation(Bukkit.getPlayer((UUID)player.getUniqueId()), "tport.command.back.PLAYER.from.succeeded", PlayerEncapsulation.asPlayer(toPlayer, UUID.fromString(toPlayerUUID))), (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.command.back.PLAYER.from.toRequested", PlayerEncapsulation.asPlayer(toPlayer, UUID.fromString(toPlayerUUID)), delay, tickMessage, seconds, secondMessage));
            return true;
        }, prevTPort -> {
            String playerName = PlayerUUID.getPlayerName((String)prevTPort.getData().get("playerUUID"));
            Location prevLoc = prevTPort.getData().getOrDefault("prevLoc", null);
            return (prevLoc == null ? "To " : "From ") + playerName;
        }, prevTPort -> {
            String playerName = PlayerUUID.getPlayerName((String)prevTPort.getData().get("playerUUID"));
            Location prevLoc = prevTPort.getData().getOrDefault("prevLoc", null);
            return ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.back.PLAYER." + (prevLoc == null ? "to" : "from") + ".previousLocation", playerName);
        }),
        DEATH((player, prevTPort, safetyCheck) -> {
            Location deathLoc = (Location)prevTPort.getData().get("deathLoc");
            Location prevLoc = prevTPort.getData().getOrDefault("prevLoc", null);
            Message deathMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varSuccessColor, ColorTheme.ColorType.varSuccess2Color, "tport.command.back.DEATH.death", new Object[0]);
            if (prevLoc == null) {
                if (safetyCheck && !SafetyCheck.isSafe(deathLoc)) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.back.DEATH.to.notSafe", deathMessage);
                    return false;
                }
                prevTPorts.put(player.getUniqueId(), new PrevTPort("DEATH", "deathLoc", (Object)deathLoc, "prevLoc", (Object)player.getLocation()));
                TPEManager.requestTeleportPlayer(player, deathLoc, () -> ColorTheme.sendSuccessTranslation(Bukkit.getPlayer((UUID)player.getUniqueId()), "tport.command.back.DEATH.to.succeeded", deathMessage), (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.command.back.DEATH.to.tpRequested", deathMessage, delay, tickMessage, seconds, secondMessage));
                return true;
            }
            if (safetyCheck && !SafetyCheck.isSafe(prevLoc)) {
                ColorTheme.sendErrorTranslation(player, "tport.command.back.DEATH.from.notSafe", deathMessage);
                return false;
            }
            prevTPorts.put(player.getUniqueId(), new PrevTPort("DEATH", "deathLoc", (Object)deathLoc, "prevLoc", null));
            TPEManager.requestTeleportPlayer(player, prevLoc, () -> ColorTheme.sendSuccessTranslation(Bukkit.getPlayer((UUID)player.getUniqueId()), "tport.command.back.DEATH.from.succeeded", deathMessage), (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.command.back.DEATH.from.tpRequested", deathMessage, delay, tickMessage, seconds, secondMessage));
            return true;
        }, prevTPort -> {
            Location prevLoc = prevTPort.getData().getOrDefault("prevLoc", null);
            return (prevLoc == null ? "To" : "From") + " death location";
        }, prevTPort -> {
            Location prevLoc = prevTPort.getData().getOrDefault("prevLoc", null);
            return ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.back.DEATH." + (prevLoc == null ? "to" : "from") + ".previousLocation", new Object[0]);
        });

        private final TPBack tpBack;
        private final BackString backString;
        private final BackMessage backMessage;

        private PrevType(TPBack tpBack, BackString backString, BackMessage backMessage) {
            this.tpBack = tpBack;
            this.backString = backString;
            this.backMessage = backMessage;
        }

        public boolean tpBack(Player player, PrevTPort prevTPort, boolean safetyCheck) {
            return this.tpBack.tpBack(player, prevTPort, safetyCheck);
        }

        public String toString(PrevTPort prevTPort) {
            return this.backString.backString(prevTPort);
        }

        public Message toMessage(PrevTPort prevTPort) {
            return this.backMessage.backMessage(prevTPort);
        }

        @FunctionalInterface
        private static interface TPBack {
            public boolean tpBack(Player var1, PrevTPort var2, boolean var3);
        }

        @FunctionalInterface
        private static interface BackString {
            public String backString(PrevTPort var1);
        }

        @FunctionalInterface
        private static interface BackMessage {
            public Message backMessage(PrevTPort var1);
        }
    }
}

