/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Add
extends SubCommand {
    private final EmptyCommand emptyAddTPortDescription = new EmptyCommand(){

        @Override
        public Message permissionsHover() {
            return ColorTheme.formatInfoTranslation("tport.command.add.tportName.description.permissionHover", "TPort.add.[X]", "TPort.edit.description", "TPort.basic", "TPort.add.<X>");
        }
    };
    public static final String[] emptyAddTPort_permissions = new String[]{"TPort.add.<X>", "TPort.add", "TPort.basic"};
    public static final String emptyAddTPort_permissionsHoverID = "tport.command.add.tportName.permissionHover";

    public Add() {
        this.emptyAddTPortDescription.setCommandName("description...", ArgumentType.OPTIONAL);
        this.emptyAddTPortDescription.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.add.tportName.description.commandDescription", "\\n", "&"));
        this.emptyAddTPortDescription.setPermissions("TPort.add.[X]", "TPort.edit.description", "TPort.basic");
        EmptyCommand emptyAddTPort = new EmptyCommand(){

            @Override
            public Message permissionsHover() {
                return ColorTheme.formatInfoTranslation(Add.emptyAddTPort_permissionsHoverID, emptyAddTPort_permissions);
            }
        };
        emptyAddTPort.setCommandName("TPort name", ArgumentType.REQUIRED);
        emptyAddTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.add.tportName.commandDescription", new Object[0]));
        emptyAddTPort.addAction(this.emptyAddTPortDescription);
        emptyAddTPort.setPermissions(emptyAddTPort_permissions);
        this.addAction(emptyAddTPort);
    }

    @Override
    public void run(String[] args, Player player) {
        TPort addedTPort;
        if (args.length == 1) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport add <TPort name> [description...]");
            ColorTheme.sendErrorTranslation(player, "tport.command.add.tportName.wrongUsage2", new Object[0]);
            return;
        }
        ItemStack item = new ItemStack(player.getInventory().getItemInMainHand());
        if (item.getType().equals((Object)Material.AIR)) {
            ColorTheme.sendErrorTranslation(player, "tport.command.add.tportName.noItem", new Object[0]);
            return;
        }
        if (args[1].length() > 50) {
            ColorTheme.sendErrorTranslation(player, "tport.command.add.tportName.nameTooLong", new Object[0]);
            return;
        }
        TPort newTPort = new TPort(player.getUniqueId(), args[1], player.getLocation(), item);
        if (args.length > 2) {
            if (this.emptyAddTPortDescription.hasPermissionToRun(player, false)) {
                newTPort.setDescription(StringUtils.join((Object[])args, (String)" ", (int)2, (int)args.length));
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.add.tportName.noDescription", "TPort.edit.description", "TPort.basic");
            }
        }
        if ((addedTPort = TPortManager.addTPort(player, newTPort, true)) != null) {
            if (Features.Feature.TPortTakesItem.isEnabled()) {
                player.getInventory().setItem(player.getInventory().getHeldItemSlot(), new ItemStack(Material.AIR));
            } else {
                addedTPort.setShouldReturnItem(false);
                addedTPort.save();
            }
        }
    }
}

