/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands;

import com.spaceman.tport.Main;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.CommandTemplate;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.HelpCommand;
import com.spaceman.tport.commands.tport.Adapter;
import com.spaceman.tport.commands.tport.Add;
import com.spaceman.tport.commands.tport.Back;
import com.spaceman.tport.commands.tport.Backup;
import com.spaceman.tport.commands.tport.BiomeTP;
import com.spaceman.tport.commands.tport.BlueMapCommand;
import com.spaceman.tport.commands.tport.Cancel;
import com.spaceman.tport.commands.tport.Delay;
import com.spaceman.tport.commands.tport.DynmapCommand;
import com.spaceman.tport.commands.tport.Edit;
import com.spaceman.tport.commands.tport.FeatureTP;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.commands.tport.GeneratePermFile;
import com.spaceman.tport.commands.tport.HistoryCommand;
import com.spaceman.tport.commands.tport.Home;
import com.spaceman.tport.commands.tport.Log;
import com.spaceman.tport.commands.tport.Look;
import com.spaceman.tport.commands.tport.MainLayout;
import com.spaceman.tport.commands.tport.MetricsCommand;
import com.spaceman.tport.commands.tport.Open;
import com.spaceman.tport.commands.tport.Own;
import com.spaceman.tport.commands.tport.PLTP;
import com.spaceman.tport.commands.tport.ParticleAnimationCommand;
import com.spaceman.tport.commands.tport.Preview;
import com.spaceman.tport.commands.tport.Public;
import com.spaceman.tport.commands.tport.Redirect;
import com.spaceman.tport.commands.tport.Reload;
import com.spaceman.tport.commands.tport.Remove;
import com.spaceman.tport.commands.tport.RemovePlayer;
import com.spaceman.tport.commands.tport.Requests;
import com.spaceman.tport.commands.tport.ResourcePack;
import com.spaceman.tport.commands.tport.Restore;
import com.spaceman.tport.commands.tport.Restriction;
import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.commands.tport.Search;
import com.spaceman.tport.commands.tport.Settings;
import com.spaceman.tport.commands.tport.Sort;
import com.spaceman.tport.commands.tport.Tag;
import com.spaceman.tport.commands.tport.Teleporter;
import com.spaceman.tport.commands.tport.Transfer;
import com.spaceman.tport.commands.tport.Version;
import com.spaceman.tport.commands.tport.Waypoints;
import com.spaceman.tport.commands.tport.WorldCommand;
import com.spaceman.tport.cooldown.CooldownCommand;
import com.spaceman.tport.events.PreviewEvents;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.colorTheme.ColorThemeCommand;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.fancyMessage.language.Language;
import com.spaceman.tport.inventories.TPortInventories;
import com.spaceman.tport.metrics.CommandCounter;
import javax.annotation.Nonnull;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TPortCommand
extends CommandTemplate {
    private static final TPortCommand instance = new TPortCommand();

    public static TPortCommand getInstance() {
        return instance;
    }

    private TPortCommand() {
        super(Main.getInstance(), false, new CommandTemplate.CommandDescription("tport", Main.getInstance().getDescription().getName(), "The command to teleport to saved locations and more", "/TPort <args...>"));
    }

    public static boolean executeTPortCommand(CommandSender sender, String args) {
        if (args == null) {
            return false;
        }
        if (args.isEmpty()) {
            return TPortCommand.executeTPortCommand(sender, new String[0]);
        }
        return TPortCommand.executeTPortCommand(sender, args.split(" "));
    }

    public static boolean executeTPortCommand(CommandSender sender, String[] args) {
        if (args == null) {
            return false;
        }
        return TPortCommand.getInstance().execute(sender, "tport", args);
    }

    public static void reRegisterActions() {
        TPortCommand.getInstance().registerActions();
    }

    @Override
    public void registerActions() {
        this.actions.clear();
        PreviewEvents.unregister();
        EmptyCommand empty = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return "";
            }
        };
        empty.setCommandName("", ArgumentType.FIXED);
        empty.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.commandDescription", new Object[0]));
        this.addAction(empty);
        this.addAction(Open.getInstance());
        this.addAction(new Add());
        this.addAction(new Remove());
        this.addAction(new Edit());
        this.addAction(new PLTP());
        this.addAction(new Teleporter());
        this.addAction(new Own());
        this.addAction(new Back());
        this.addAction(new BiomeTP());
        this.addAction(new FeatureTP());
        this.addAction(new Home());
        this.addAction(new ColorThemeCommand());
        this.addAction(new Reload());
        this.addAction(CooldownCommand.getInstance());
        this.addAction(new RemovePlayer());
        this.addAction(new Public());
        this.addAction(new Transfer());
        this.addAction(new Version());
        this.addAction(new Log());
        this.addAction(new Backup());
        this.addAction(new ParticleAnimationCommand());
        this.addAction(new Delay());
        this.addAction(new Restriction());
        this.addAction(new Cancel());
        this.addAction(new Redirect());
        this.addAction(Search.getInstance());
        this.addAction(new Sort());
        this.addAction(new Tag());
        this.addAction(new SafetyCheck());
        this.addAction(new MetricsCommand());
        this.addAction(new DynmapCommand());
        this.addAction(new BlueMapCommand());
        this.addAction(new MainLayout());
        this.addAction(new WorldCommand());
        this.addAction(new Requests());
        this.addAction(new Features());
        this.addAction(new Language());
        this.addAction(new Preview());
        this.addAction(new ResourcePack());
        this.addAction(new Restore());
        this.addAction(new Settings());
        this.addAction(new Look());
        this.addAction(new Adapter());
        this.addAction(new HistoryCommand());
        this.addAction(new GeneratePermFile(this));
        this.addAction(new Waypoints());
        TextComponent discordServer = new TextComponent("Discord Server", ColorTheme.ColorType.varInfoColor).addTextEvent(new HoverEvent(new TextComponent("https://discord.gg/tq5RTmSbHU", ColorTheme.ColorType.infoColor))).addTextEvent(ClickEvent.openUrl("https://discord.gg/tq5RTmSbHU"));
        Message helpMessage = ColorTheme.formatInfoTranslation("tport.command.help.succeeded", discordServer);
        HelpCommand helpCommand = new HelpCommand(this, helpMessage, true);
        if (Features.Feature.Dynmap.isEnabled()) {
            EmptyCommand emptyHelpDynmap = new EmptyCommand(){

                @Override
                public String getName(String argument) {
                    return this.getCommandName();
                }
            };
            emptyHelpDynmap.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.help.dynmap.commandDescription", new Object[0]));
            emptyHelpDynmap.setRunnable((args, player) -> TPortCommand.executeTPortCommand((CommandSender)player, "dynmap"));
            helpCommand.addExtraHelp("Dynmap", emptyHelpDynmap);
        }
        if (Features.Feature.PLTP.isEnabled()) {
            helpCommand.addExtraTranslatedHelp("PLTP", ColorTheme.formatInfoTranslation("tport.command.help.PLTP.description", "/tport PLTP state off"));
        }
        helpCommand.addExtraTranslatedHelp("Redirects", ColorTheme.formatInfoTranslation("tport.command.help.redirects.description", "/tp <player>", "/tport PLTP tp <player>"));
        helpCommand.addExtraTranslatedHelp("Language", ColorTheme.formatInfoTranslation("tport.command.help.language.description", "server", "custom", "https://github.com/JasperBouwman/TPort/tree/master/src/lang"));
        helpCommand.addExtraTranslatedHelp("Cooldown", ColorTheme.formatInfoTranslation("tport.command.help.cooldown.description", "/tport cooldown <cooldown> <value>", "permission", "TPort.cooldown.<cooldown>.<value>"));
        this.addAction(helpCommand);
    }

    @Override
    public boolean execute(@Nonnull CommandSender sender, @Nonnull String command, @Nonnull String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("You have to be a player to use this command");
            return false;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            TPortInventories.openMainTPortGUI(player);
        } else if (this.runCommands(args[0], args, player)) {
            CommandCounter.add(args);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.invalidSubCommand", args[0]);
        }
        return false;
    }
}

