/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.biomeTP;

import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import com.spaceman.tport.Main;
import com.spaceman.tport.Pair;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commands.tport.BiomeTP;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.MessageUtils;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.BiomeEncapsulation;
import com.spaceman.tport.fancyMessage.inventories.FancyClickEvent;
import com.spaceman.tport.fancyMessage.language.Language;
import com.spaceman.tport.inventories.TPortInventories;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public record BiomePreset(String name, List<String> biomes, boolean whitelist, Material material, boolean fromMC) {
    private static final ArrayList<BiomePreset> biomePresets = new ArrayList();
    private static final HashMap<String, ArrayList<BiomePreset>> tagPresets = new HashMap();

    public static ArrayList<BiomePreset> getBiomePresets() {
        return new ArrayList<BiomePreset>(biomePresets);
    }

    public static ArrayList<BiomePreset> getTagPresets(World world) {
        ArrayList<BiomePreset> list = new ArrayList<BiomePreset>();
        ArrayList<BiomePreset> tagPreset = tagPresets.getOrDefault(world.getName(), null);
        if (tagPreset == null) {
            tagPreset = Main.getOrDefault(BiomePreset.loadPresetsFromWorld(world), new ArrayList());
        }
        for (BiomePreset preset : tagPreset) {
            if (!list.stream().noneMatch(p -> p.name().equalsIgnoreCase(preset.name()))) continue;
            list.add(preset);
        }
        return list;
    }

    public static Pair<Boolean, List<String>> registerPreset(String name, List<String> biomes, boolean whitelist, Material material) {
        if (Main.containsSpecialCharacter(name)) {
            return new Pair<Boolean, List<String>>(false, biomes);
        }
        if (biomePresets.stream().map(BiomePreset::name).anyMatch(n -> n.equalsIgnoreCase(name))) {
            return new Pair<Boolean, List<String>>(false, biomes);
        }
        List<String> availableBiomes = BiomeTP.availableBiomes();
        ArrayList<String> biomeList = new ArrayList<String>();
        ArrayList<String> errorList = new ArrayList<String>();
        for (String biome : biomes) {
            String b = biome.toLowerCase();
            if (availableBiomes.stream().anyMatch(b::equals)) {
                biomeList.add(b);
                continue;
            }
            errorList.add(biome);
        }
        if (biomeList.isEmpty()) {
            return new Pair<Boolean, List<String>>(false, errorList);
        }
        biomePresets.add(new BiomePreset(name, biomeList, whitelist, material, false));
        return new Pair<Boolean, List<String>>(true, errorList);
    }

    public static List<String> getNames(World world) {
        List<String> list = biomePresets.stream().map(BiomePreset::name).collect(Collectors.toList());
        ArrayList tagPreset = tagPresets.getOrDefault(world.getName(), null);
        if (tagPreset == null) {
            tagPreset = Main.getOrDefault(BiomePreset.loadPresetsFromWorld(world), new ArrayList());
        }
        tagPreset.stream().map(BiomePreset::name).forEach(list::add);
        return list;
    }

    public static List<ItemStack> getItems(Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ColorTheme colorTheme = ColorTheme.getTheme(player);
        ArrayList tagPreset = tagPresets.getOrDefault(player.getWorld().getName(), null);
        if (tagPreset == null) {
            tagPreset = Main.getOrDefault(BiomePreset.loadPresetsFromWorld(player.getWorld()), new ArrayList());
        }
        for (BiomePreset preset : Iterables.concat(biomePresets, (Iterable)tagPreset)) {
            ItemStack is = new ItemStack(preset.material());
            JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
            List<Message> lore = new LinkedList<Message>();
            lore.add(new Message());
            Object baseType = "tport.commands.tport.biomeTP.biomeTPPresets.getItems.type";
            baseType = preset.biomes().size() == 1 ? (String)baseType + ".singular" : (String)baseType + ".multiple";
            if (preset.whitelist()) {
                lore.add(ColorTheme.formatInfoTranslation((String)baseType, ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.commands.tport.biomeTP.biomeTPPresets.getItems.whitelist", new Object[0])));
            } else {
                lore.add(ColorTheme.formatInfoTranslation((String)baseType, ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.commands.tport.biomeTP.biomeTPPresets.getItems.blacklist", new Object[0])));
            }
            Message lorePiece = new Message();
            boolean color = true;
            for (int i = 0; i < preset.biomes().size(); ++i) {
                if (i % 2 == 0 && i != 0) {
                    lore.add(lorePiece);
                    lorePiece = new Message();
                }
                if (color) {
                    lorePiece.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "%s", new BiomeEncapsulation(preset.biomes().get(i))));
                } else {
                    lorePiece.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfo2Color, ColorTheme.ColorType.varInfo2Color, "%s", new BiomeEncapsulation(preset.biomes().get(i))));
                }
                lorePiece.addText(TextComponent.textComponent(", ", ColorTheme.ColorType.infoColor));
                color = !color;
            }
            lorePiece.removeLast();
            lore.add(lorePiece);
            if (preset.fromMC()) {
                lore.add(new Message());
                lore.add(ColorTheme.formatInfoTranslation("tport.commands.tport.biomeTP.biomeTPPresets.getItems.fromMC", new Object[0]));
                lore.add(new Message(TextComponent.textComponent(preset.name(), ColorTheme.ColorType.varInfoColor)));
            }
            lore.add(new Message());
            lore.add(ColorTheme.formatInfoTranslation("tport.commands.tport.biomeTP.biomeTPPresets.getItems.selectBiomes.additive." + (preset.biomes().size() == 1 ? "singular" : "multiple"), ClickType.LEFT));
            lore.add(ColorTheme.formatInfoTranslation("tport.commands.tport.biomeTP.biomeTPPresets.getItems.selectBiomes.overwrite." + (preset.biomes().size() == 1 ? "singular" : "multiple"), ClickType.SHIFT_LEFT));
            lore.add(ColorTheme.formatInfoTranslation("tport.commands.tport.biomeTP.biomeTPPresets.getItems.runPreset", ClickType.RIGHT));
            lore = MessageUtils.translateMessage(lore, playerLang);
            ColorTheme.ColorType titleColor = preset.fromMC() ? ColorTheme.ColorType.varInfo2Color : ColorTheme.ColorType.varInfoColor;
            Message biomeTitle = ColorTheme.formatTranslation(titleColor, titleColor, "%s", preset.name());
            MessageUtils.setCustomItemData(is, colorTheme, biomeTitle, lore);
            ItemMeta im = is.getItemMeta();
            if (im == null) continue;
            FancyClickEvent.addCommand(im, ClickType.RIGHT, "tport biomeTP preset " + preset.name());
            im.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getInstance(), "biomePreset/name"), PersistentDataType.STRING, (Object)preset.name());
            im.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getInstance(), "biomePreset/whitelist"), PersistentDataType.INTEGER, (Object)(preset.whitelist() ? 1 : 0));
            im.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getInstance(), "biomePreset/biomesFromPreset"), (PersistentDataType)PersistentDataType.LIST.strings(), preset.biomes());
            FancyClickEvent.addFunction(im, (whoClicked, clickType, pdc, fancyInventory) -> {
                NamespacedKey whitelistKey = new NamespacedKey((Plugin)Main.getInstance(), "biomePreset/whitelist");
                NamespacedKey biomesFromPresetKey = new NamespacedKey((Plugin)Main.getInstance(), "biomePreset/biomesFromPreset");
                if (pdc.has(biomesFromPresetKey, (PersistentDataType)PersistentDataType.LIST.strings()) && pdc.has(whitelistKey, PersistentDataType.INTEGER)) {
                    List biomesFromPreset = (List)pdc.getOrDefault(biomesFromPresetKey, (PersistentDataType)PersistentDataType.LIST.strings(), new ArrayList());
                    Integer isWhitelist = Main.getOrDefault((Integer)pdc.get(whitelistKey, PersistentDataType.INTEGER), 1);
                    Set<String> biomeSelection = clickType == ClickType.LEFT ? fancyInventory.getData(TPortInventories.biomeSelectionDataName) : new HashSet();
                    int originalSelectionSize = biomeSelection.size();
                    List<String> availableBiomes = BiomeTP.availableBiomes(whoClicked.getWorld());
                    if (isWhitelist == 1) {
                        for (String biome : biomesFromPreset) {
                            if (!availableBiomes.contains(biome)) continue;
                            biomeSelection.add(biome);
                        }
                    } else {
                        for (String availableBiome : availableBiomes) {
                            if (biomesFromPreset.contains(availableBiome)) continue;
                            biomeSelection.add(availableBiome);
                        }
                    }
                    if (originalSelectionSize == biomeSelection.size()) {
                        ColorTheme.sendErrorTranslation(whoClicked, "tport.commands.tport.biomeTP.biomeTPPresets.getItems.noBiomesLeft", new Object[0]);
                    }
                    fancyInventory.setData(TPortInventories.biomeSelectionDataName, biomeSelection);
                    TPortInventories.openBiomeTP(whoClicked, 0, fancyInventory);
                    TPortAdvancement.Advancement_BiomeTP_OneIsNotEnough.grant(whoClicked);
                }
            }, ClickType.LEFT, ClickType.SHIFT_LEFT);
            is.setItemMeta(im);
            items.add(is);
        }
        return items;
    }

    public static String getMaterialName(String tagKeyName) {
        return switch (tagKeyName) {
            case "is_deep_ocean", "is_river", "is_ocean", "reduce_water_ambient_spawns", "water_on_map_outlines", "has_closer_water_fog" -> "WATER_BUCKET";
            case "is_mountain" -> "STONE";
            case "is_hill", "is_overworld" -> "GRASS_BLOCK";
            case "is_taiga" -> "SPRUCE_LOG";
            case "is_beach" -> "SAND";
            case "is_badlands" -> "TERRACOTTA";
            case "is_nether" -> "NETHERRACK";
            case "is_jungle" -> "JUNGLE_LOG";
            case "is_forest" -> "OAK_SAPLING";
            case "without_zombie_sieges" -> "ZOMBIE_HEAD";
            case "required_ocean_monument_surrounding" -> "DARK_PRISMARINE";
            case "spawns_cold_variant_frogs" -> "VERDANT_FROGLIGHT";
            case "spawns_temperate_variant_frogs" -> "OCHRE_FROGLIGHT";
            case "spawns_warm_variant_frogs" -> "PEARLESCENT_FROGLIGHT";
            case "without_patrol_spawns" -> "RAVAGER_SPAWN_EGG";
            case "allows_surface_slime_spawns" -> "SLIME_BALL";
            case "without_wandering_trader_spawns" -> "WANDERING_TRADER_SPAWN_EGG";
            case "polar_bears_spawn_on_alternate_blocks" -> "POLAR_BEAR_SPAWN_EGG";
            case "is_end" -> "END_STONE";
            case "plays_underwater_music" -> "MUSIC_DISC_MALL";
            case "only_allows_snow_and_gold_rabbits", "spawns_gold_rabbits", "spawns_white_rabbits" -> "RABBIT_SPAWN_EGG";
            case "more_frequent_drowned_spawns" -> "DROWNED_SPAWN_EGG";
            case "allows_tropical_fish_spawns_at_any_height" -> "TROPICAL_FISH_SPAWN_EGG";
            case "produces_corals_from_bonemeal" -> "BRAIN_CORAL";
            case "is_savanna" -> "ACACIA_LOG";
            case "stronghold_biased_to" -> "END_PORTAL_FRAME";
            case "mineshaft_blocking" -> "CHEST_MINECART";
            case "snow_golem_melts" -> "CARVED_PUMPKIN";
            case "spawns_snow_foxes" -> "FOX_SPAWN_EGG";
            case "increased_fire_burnout" -> "FLINT_AND_STEEL";
            case "spawns_warm_variant_farm_animals" -> "COW_SPAWN_EGG";
            case "spawns_cold_variant_farm_animals" -> "CHICKEN_SPAWN_EGG";
            default -> "DIAMOND_BLOCK";
        };
    }

    public static ArrayList<BiomePreset> loadPresetsFromWorld(World world) {
        ArrayList<BiomePreset> returnList = null;
        if (!BiomeTP.legacyBiomeTP) {
            try {
                returnList = Main.getInstance().adapter.loadPresetsFromWorld(world);
            }
            catch (Throwable ex) {
                Features.Feature.printSmallNMSErrorInConsole("BiomeTP Minecraft tags", false);
                if (Features.Feature.PrintErrorsInConsole.isEnabled()) {
                    ex.printStackTrace();
                }
                BiomeTP.legacyBiomeTP = true;
            }
            if (returnList != null) {
                tagPresets.put(world.getName(), returnList);
            }
        }
        return returnList;
    }

    public static BiomePreset getPreset(String name, World world) {
        for (BiomePreset preset : biomePresets) {
            if (!preset.name().equalsIgnoreCase(name)) continue;
            return preset;
        }
        ArrayList<BiomePreset> tagPreset = tagPresets.getOrDefault(world.getName(), null);
        if (tagPreset == null) {
            tagPreset = Main.getOrDefault(BiomePreset.loadPresetsFromWorld(world), new ArrayList());
        }
        for (BiomePreset preset : tagPreset) {
            if (!preset.name().equalsIgnoreCase(name)) continue;
            return preset;
        }
        return null;
    }
}

