/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.advancements;

import com.google.gson.JsonObject;
import com.spaceman.tport.Main;
import com.spaceman.tport.advancements.CustomJSONMessage;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.advancements.TPortAdvancementsModels;
import com.spaceman.tport.commands.tport.ResourcePack;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.fancyMessage.language.Language;
import eu.endercentral.crazy_advancements.JSONMessage;
import eu.endercentral.crazy_advancements.NameKey;
import eu.endercentral.crazy_advancements.advancement.Advancement;
import eu.endercentral.crazy_advancements.advancement.AdvancementDisplay;
import eu.endercentral.crazy_advancements.advancement.AdvancementFlag;
import eu.endercentral.crazy_advancements.manager.AdvancementManager;
import eu.endercentral.crazy_advancements.packet.AdvancementsPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class TPortAdvancementManager {
    private static final HashMap<UUID, TPortAdvancementManager> advancements = new HashMap();
    private final Player player;
    private AdvancementManager advancementManager = null;

    private static TPortAdvancementManager createAdvancementManager(Player player) {
        TPortAdvancementManager tportManager = new TPortAdvancementManager(player);
        advancements.put(player.getUniqueId(), tportManager);
        return tportManager;
    }

    public static TPortAdvancementManager getOrCreateManager(Player player) {
        TPortAdvancementManager tportManager = advancements.get(player.getUniqueId());
        if (tportManager == null) {
            tportManager = TPortAdvancementManager.createAdvancementManager(player);
        }
        return tportManager;
    }

    public static void removeAdvancementManager(Player player) {
        TPortAdvancementManager manager = TPortAdvancementManager.getOrCreateManager(player);
        manager.advancementManager.resetAccessible();
        advancements.remove(player.getUniqueId());
    }

    static void grantAdvancement(@Nullable Player player, TPortAdvancement advancement) {
        if (player == null) {
            return;
        }
        TPortAdvancementManager tportManager = TPortAdvancementManager.getOrCreateManager(player);
        Advancement advancement1 = tportManager.advancementManager.getAdvancement(TPortAdvancementManager.toPersonafiedNameKey(advancement.key(), player));
        if (advancement1 == null) {
            return;
        }
        if (!advancement1.isGranted(player)) {
            tportManager.advancementManager.grantAdvancement(player, advancement1);
            advancement1.displayToast(player);
            String texID = switch (advancement1.getDisplay().getFrame()) {
                default -> throw new IncompatibleClassChangeError();
                case AdvancementDisplay.AdvancementFrame.TASK -> "tport.advancements.task";
                case AdvancementDisplay.AdvancementFrame.GOAL -> "tport.advancements.goal";
                case AdvancementDisplay.AdvancementFrame.CHALLENGE -> "tport.advancements.challenge";
            };
            Message chat = ColorTheme.formatTranslation(ChatColor.WHITE, ChatColor.GREEN, texID, player, advancement);
            chat.broadcastTranslation();
            tportManager.advancementManager.saveProgress(player, new Advancement[]{advancement1});
            TPortAdvancementManager.reInitAdvancements(player);
        }
    }

    public static void reInitAdvancements(Player player) {
        TPortAdvancementManager.removeAdvancementManager(player);
        TPortAdvancementManager.getOrCreateManager(player);
    }

    private static NameKey toPersonafiedNameKey(String key, Player player) {
        return new NameKey(Main.getInstance().getName(), key + "_" + player.getName());
    }

    private static NameKey toPersonafiedNameKey(NameKey nameKey, Player player) {
        return new NameKey(Main.getInstance().getName(), nameKey.getKey() + "_" + player.getName());
    }

    public TPortAdvancementManager(Player player) {
        this.player = player;
        this.createAdvancements();
        this.advancementManager.loadProgress(player, new Advancement[0]);
        AdvancementsPacket removeAdvancements = new AdvancementsPacket(player, false, null, this.advancementManager.getAdvancements().stream().map(Advancement::getName).toList());
        removeAdvancements.send();
        ArrayList<Advancement> list = new ArrayList<Advancement>();
        for (Advancement a : this.advancementManager.getAdvancements()) {
            if (!a.getDisplay().getVisibility().isVisible(player, a)) continue;
            list.add(a);
        }
        AdvancementsPacket addAdvancements = new AdvancementsPacket(player, false, list, null);
        addAdvancements.send();
    }

    private void createAdvancements() {
        try {
            ColorTheme colorTheme = ColorTheme.getTheme(this.player);
            JsonObject playerLang = Language.getPlayerLang(this.player);
            TPortAdvancement mainAdvancement = TPortAdvancement.Advancement_TPort;
            AdvancementDisplay display = new AdvancementDisplay(mainAdvancement.model().getItem(this.player), mainAdvancement.translationID(), mainAdvancement.translationID(), mainAdvancement.frame().getFrame(), mainAdvancement.visibility().getVisibility());
            display.setTitle((JSONMessage)new CustomJSONMessage(ColorTheme.formatInfoTranslation("tport.advancements." + mainAdvancement.translationID() + ".title", new Object[0]).translateMessage(playerLang), colorTheme));
            display.setDescription((JSONMessage)new CustomJSONMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.advancements." + mainAdvancement.translationID() + ".description", new Object[0]).translateMessage(playerLang), colorTheme));
            if (ResourcePack.getResourcePackState(this.player.getUniqueId())) {
                InventoryModel background = TPortAdvancementsModels.advancement_background_model;
                String namespace = background.getNamespacedKey().getNamespace();
                Object textureName = background.getNamespacedKey().getKey();
                if (background.hasSubDir()) {
                    textureName = background.getSubDir() + "/" + (String)textureName;
                }
                display.setBackgroundTexture(namespace + ":textures/item/" + (String)textureName + ".png");
            } else {
                display.setBackgroundTexture("textures/block/dirt.png");
            }
            Advancement advancement = new Advancement(null, TPortAdvancementManager.toPersonafiedNameKey(mainAdvancement.key(), this.player), display, new AdvancementFlag[0]);
            this.advancementManager = new AdvancementManager(TPortAdvancementManager.toPersonafiedNameKey("manager", this.player), new Player[0]);
            this.advancementManager.makeAccessible();
            this.advancementManager.addAdvancement(new Advancement[]{advancement});
            this.advancementManager.addPlayer(this.player);
            for (TPortAdvancement tportAdvancement : TPortAdvancement.tportAdvancements) {
                TPortAdvancement parent = tportAdvancement.parent();
                Advancement p = parent == null ? advancement : this.advancementManager.getAdvancement(TPortAdvancementManager.toPersonafiedNameKey(parent.key(), this.player));
                AdvancementDisplay saved_display = new AdvancementDisplay(tportAdvancement.model().getItem(this.player), tportAdvancement.translationID(), tportAdvancement.translationID(), tportAdvancement.frame().getFrame(), tportAdvancement.visibility().getVisibility());
                saved_display.setTitle((JSONMessage)new CustomJSONMessage(ColorTheme.formatInfoTranslation("tport.advancements." + tportAdvancement.translationID() + ".title", new Object[0]).translateMessage(playerLang), colorTheme));
                saved_display.setDescription((JSONMessage)new CustomJSONMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.advancements." + tportAdvancement.translationID() + ".description", new Object[0]).translateMessage(playerLang), colorTheme));
                saved_display.setCoordinates(tportAdvancement.x(), tportAdvancement.y());
                Advancement a = new Advancement(p, TPortAdvancementManager.toPersonafiedNameKey(tportAdvancement.key(), this.player), saved_display, new AdvancementFlag[0]);
                this.advancementManager.addAdvancement(new Advancement[]{a});
            }
        }
        catch (Error | Exception ignore) {
            ignore.printStackTrace();
        }
    }

    public static enum AdvancementFrame {
        TASK("TASK"),
        GOAL("GOAL"),
        CHALLENGE("CHALLENGE");

        private final String frame;

        private AdvancementFrame(String frame) {
            this.frame = frame;
        }

        AdvancementDisplay.AdvancementFrame getFrame() {
            return AdvancementDisplay.AdvancementFrame.parse((String)this.frame);
        }
    }

    public static enum AdvancementVisibility {
        ALWAYS("ALWAYS"),
        PARENT_GRANTED("PARENT_GRANTED"),
        VANILLA("VANILLA"),
        HIDDEN("HIDDEN");

        private final String visibility;

        private AdvancementVisibility(String visibility) {
            this.visibility = visibility;
        }

        public eu.endercentral.crazy_advancements.advancement.AdvancementVisibility getVisibility() {
            return eu.endercentral.crazy_advancements.advancement.AdvancementVisibility.parseVisibility((String)this.visibility);
        }
    }
}

